package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.HeaderFieldTypeImpl.HeaderFieldType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.BiDirectionalMap;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.EnumMapping;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class HeaderFieldTypeImpl extends EnumMapping<HeaderFieldType> {

	public enum HeaderFieldType {

		GENERATION_TIME, // 0
		GENERATION_TIME_STANDARD_DEVIATION, // 1
		EXPIRATION, // 2
		GENERATION_LOCATION, // 3
		REQUEST_UNRECOGNIZED_CERTIFICATE, // 4
		ITS_AID, // 5
		SIGNER_INFO, // 128
		ENCRYPTION_PARAMETERS, // 129
		RECIPIENT_INFO; // 130

	}
	
	private static HeaderFieldTypeImpl instance = null;

	private HeaderFieldTypeImpl() {
	}

	public static HeaderFieldTypeImpl getInstance() {
		if (instance == null)
			return new HeaderFieldTypeImpl();
		return instance;
	}

	@Override
	protected void initMapping(BiDirectionalMap<Integer, HeaderFieldType> map) {
		map.put(0, HeaderFieldType.GENERATION_TIME);
		map.put(1, HeaderFieldType.GENERATION_TIME_STANDARD_DEVIATION);
		map.put(2, HeaderFieldType.EXPIRATION);
		map.put(3, HeaderFieldType.GENERATION_LOCATION);
		map.put(4, HeaderFieldType.REQUEST_UNRECOGNIZED_CERTIFICATE);
		map.put(5, HeaderFieldType.ITS_AID);
		map.put(128, HeaderFieldType.SIGNER_INFO);
		map.put(129, HeaderFieldType.ENCRYPTION_PARAMETERS);
		map.put(130, HeaderFieldType.RECIPIENT_INFO);
	}

}
