package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Duration.DurationType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.BiDirectionalMap;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.EnumMapping;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class DurationTypeImpl extends EnumMapping<DurationType> {

	private static DurationTypeImpl instance = null;

	private DurationTypeImpl() {
	}

	public static DurationTypeImpl getInstance() {
		if (instance == null)
			instance = new DurationTypeImpl();
		return instance;
	}

	@Override
	protected void initMapping(BiDirectionalMap<Integer, DurationType> map) {
		map.put(0, DurationType.SECONDS);
		map.put(1, DurationType.MINUTES);
		map.put(2, DurationType.HOURS);
		map.put(3, DurationType.SIXTY_HOUR_BLOCKS);
		map.put(4, DurationType.YEARS);
	}

}
