#!/bin/bash
# Copyright ETSI 2018
# See: https://forge.etsi.org/etsi-forge-copyright-statement.txt

set -e
set -vx

DOCKER_FILE=./Dockerfile
if [ -f ${DOCKER_FILE} ]
then
    IMAGES=$(docker images -q)
    if [ "${IMAGES}" != "" ]
    then
      docker rmi -f $(docker images -q)
    fi
    docker build --tag stf525_its --force-rm --build-arg ssh_pub_key="$(cat ~/.ssh/id_rsa.pub)" .
    if [ "$?" != "0" ]
    then
        echo "Docker build failed: $?"
        exit -1
    fi
    docker image ls -a
    docker inspect stf525_its:latest
    if [ "$?" != "0" ]
    then
        echo "Docker inspect failed: $?"
        exit -1
    fi
else
    exit -2
fi

# That's all Floks
exit 0
