#include <string>
//#include <typeinfo>

#include "uppertester_mapem_spatem_codec.hh"
#include "loggers.hh"

#include "uppertester_types.hh"

#include "mapem_codec.hh"
#include "spatem_codec.hh"

template <typename T_type> class OPTIONAL;
class TTCN_EncDec;

int uppertester_mapem_spatem_codec::encode (const Record_Type& msg, OCTETSTRING& data)
{
  loggers::get_instance().log_msg(">>> uppertester_mapem_spatem_codec::encode: ", (const Record_Type&)msg);
  
  TTCN_EncDec::clear_error();
  TTCN_Buffer encoding_buffer;
  if (std::string(msg.get_descriptor()->name).compare("@LibItsMapemSpatem_TypesAndValues.UtMapemSpatemInitialize") == 0) {
    encoding_buffer.put_c(static_cast<const unsigned char>(uppertester_mapem_spatem_codec::c_utMapemSpatemInitialize));
  } else if (std::string(msg.get_descriptor()->name).compare("@LibItsMapemSpatem_TypesAndValues.UtMapemSpatemTrigger") == 0) {
    encoding_buffer.put_c(static_cast<const unsigned char>(uppertester_mapem_spatem_codec::c_utMapemSpatemTrigger));
  } else { // Error
    data = OCTETSTRING();
    loggers::get_instance().log("<<< uppertester_mapem_spatem_codec::encode: Return -1");
    return -1;
  }
  encode_(msg, *msg.get_descriptor(), encoding_buffer);
  data = OCTETSTRING(encoding_buffer.get_len(), encoding_buffer.get_data());
  loggers::get_instance().log_msg("<<< uppertester_mapem_spatem_codec::encode: data=", data);
  return 0;
}

int uppertester_mapem_spatem_codec::encode_ (const Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& encoding_buffer)
{
  loggers::get_instance().log(">>> uppertester_mapem_spatem_codec::encode_: processing %s/%s/%p", type.get_descriptor()->name, field_descriptor.name, dynamic_cast<const Record_Type*>(&type));
  loggers::get_instance().log_msg(">>> uppertester_mapem_spatem_codec::encode_: ", type);
  
  if (dynamic_cast<const Record_Type*>(&type) != NULL) {
    const Record_Type& r = (const Record_Type &)type;
    loggers::get_instance().log("uppertester_mapem_spatem_codec::encode_: processing Record_Type %s", r.get_descriptor()->name);
    for(int i = 0; i < r.get_count(); i++) {
      loggers::get_instance().log("uppertester_mapem_spatem_codec::encode_: processing %s/%s/%s - %d (1 ==> use dynamic_cast<const OPTIONAL<...>) - %d", r.fld_name(i), r.fld_descr(i)->name, r.get_at(i)->get_descriptor()->name, r.get_at(i)->is_optional(), r.get_at(i)->is_present());
      if (r.get_at(i)->is_present()) {
        if (encode_(*r.get_at(i), *r.fld_descr(i), encoding_buffer) == -1) {
          loggers::get_instance().warning("uppertester_mapem_spatem_codec::encode_: -1 result code returned");
          return -1;
        }
      } else if (std::string(r.fld_name(i)).compare("alacarte") == 0) {
        // Add empty field length
        loggers::get_instance().log("uppertester_mapem_spatem_codec::encode_: alacarte is missing, add 0x00");
        encoding_buffer.put_c(0x00);
      }
    } // End of 'for' statement
  } else {
    std::string s(field_descriptor.name);
    loggers::get_instance().log("uppertester_mapem_spatem_codec::encode_: field to process %s", s.c_str());
      loggers::get_instance().log("uppertester_mapem_spatem_codec::encode_ (else): processing type %s/%s", type.get_descriptor()->name, field_descriptor.name);
      type.encode(field_descriptor, encoding_buffer, TTCN_EncDec::CT_RAW);

  }
  
  loggers::get_instance().log_to_hexa("<<<uppertester_mapem_spatem_codec::encode_: encoding_buffer=", encoding_buffer);
  return 0;
}

int uppertester_mapem_spatem_codec::decode (const OCTETSTRING& data, Record_Type& msg, params* params)
{
  TTCN_EncDec::clear_error();
  TTCN_Buffer decoding_buffer(data);
  _params = params;
  
  loggers::get_instance().log_to_hexa(">>> uppertester_mapem_spatem_codec::decode: decoding_buffer=", decoding_buffer);
  //decode_(msg, *msg.get_descriptor(), decoding_buffer);
  
  loggers::get_instance().log_msg("<<< uppertester_mapem_spatem_codec::decode: ", (const Record_Type&)msg);
  return 0;
}

std::unique_ptr<Base_Type> uppertester_mapem_spatem_codec::decode (const OCTETSTRING& data, params* params) {

  std::unique_ptr<Base_Type> result;
  
  const unsigned char* ptr = static_cast<const unsigned char*>(data);
  if ((*ptr != uppertester_mapem_spatem_codec::c_utMapemEventInd) && (*ptr != uppertester_mapem_spatem_codec::c_utSpatemEventInd)) {
    LibItsMapemSpatem__TypesAndValues::UtMapemSpatemResults res;
    decode(data, res, params);
    result.reset((Base_Type *)res.clone());
  } else if (*ptr == uppertester_mapem_spatem_codec::c_utMapemEventInd) {
    LibItsMapemSpatem__TypesAndValues::UtMapemEventInd ind;
    decode(data, ind, params);
    result.reset((Base_Type *)ind.clone());
  } else {
    LibItsMapemSpatem__TypesAndValues::UtSpatemEventInd ind;
    decode(data, ind, params);
    result.reset((Base_Type *)ind.clone());
  }

  return result;
}

int uppertester_mapem_spatem_codec::decode (const OCTETSTRING& data, LibItsMapemSpatem__TypesAndValues::UtMapemSpatemResults& msg, params* params)
{
  loggers::get_instance().log_to_hexa(">>> uppertester_mapem_spatem_codec::decode: decoding_buffer=", data);

  
  loggers::get_instance().log_msg("<<< uppertester_mapem_spatem_codec::decode", msg);
  return 0;
}

int uppertester_mapem_spatem_codec::decode (const OCTETSTRING& data, LibItsMapemSpatem__TypesAndValues::UtMapemEventInd& msg, params* params)
{
  loggers::get_instance().log_to_hexa(">>> uppertester_mapem_spatem_codec::decode: decoding_buffer=", data);

  
  loggers::get_instance().log_msg("<<< uppertester_mapem_spatem_codec::decode", msg);
  return 0;
}

int uppertester_mapem_spatem_codec::decode (const OCTETSTRING& data, LibItsMapemSpatem__TypesAndValues::UtSpatemEventInd& msg, params* params)
{
  loggers::get_instance().log_to_hexa(">>> uppertester_mapem_spatem_codec::decode: decoding_buffer=", data);

  
  loggers::get_instance().log_msg("<<< uppertester_mapem_spatem_codec::decode", msg);
  return 0;
}
