#include "mapem_spatem_types.hh"

#include "mapem_spatem_layer_factory.hh"

#include "loggers.hh"

mapem_spatem_layer::mapem_spatem_layer(const std::string & p_type, const std::string & param) : t_layer<LibItsMapemSpatem__TestSystem::MapemSpatemPort>(p_type), _params(), _mapem_codec(), _spatem_codec() {
  loggers::get_instance().log(">>> mapem_spatem_layer::mapem_spatem_layer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  params::convert(_params, param);
}

void mapem_spatem_layer::sendMsg(const LibItsMapemSpatem__TestSystem::MapemReq& p, params& params){
  loggers::get_instance().log_msg(">>> mapem_spatem_layer::sendMsg: ", p);

  // Encode mapem PDU
  OCTETSTRING data;
  if (_mapem_codec.encode(p.msgOut(), data) == -1) {
    loggers::get_instance().warning("mapem_spatem_layer::sendMsg: Encodeing failure");
    return;
  }
  // Update parameters
  send_data(data, params);
}

void mapem_spatem_layer::sendMsg(const LibItsMapemSpatem__TestSystem::SpatemReq& p, params& params){
  loggers::get_instance().log_msg(">>> mapem_spatem_layer::sendMsg: ", p);

  // Encode spatem PDU
  OCTETSTRING data;
  if (_spatem_codec.encode(p.msgOut(), data) == -1) {
    loggers::get_instance().warning("mapem_spatem_layer::sendMsg: Encodeing failure");
    return;
  }
  send_data(data, params);
}

void mapem_spatem_layer::send_data(OCTETSTRING& data, params& params) {
  loggers::get_instance().log_msg(">>> mapem_spatem_layer::send_data: ", data);
  //params.log();
  send_to_all_layers(data, params);
}

void mapem_spatem_layer::receive_data(OCTETSTRING& data, params& params)
{
  loggers::get_instance().log_msg(">>> mapem_spatem_layer::receive_data: ", data);
  
  // Sanity check
  if (*(static_cast<const unsigned char*>(data)+ 1) == 0x04) { // Check that received packet has MAPE message id 
    // Decode the MAPEM payload
    LibItsMapemSpatem__TestSystem::MapemInd p;
    _mapem_codec.decode(data, p.msgIn());
    if (!p.msgIn().is_bound()) {
      // Discard it
      return;
    } // else, continue
  } else if (*(static_cast<const unsigned char*>(data)+ 1) == 0x05) { // Check that received packet has SPATE message id 
    // Decode the SPATEM payload
    LibItsMapemSpatem__TestSystem::SpatemInd p;
    _spatem_codec.decode(data, p.msgIn());
    if (!p.msgIn().is_bound()) {
      // Discard it
      return;
    } // else, continue
  } else {
    // Not a DENM message, discard it
    loggers::get_instance().warning("mapem_spatem_layer::receive_data: Wrong message id: 0x%02x", *(static_cast<const unsigned char*>(data)+ 1));
    return;
  }
  
  // TODO Process lower layer data
  // gnNextHeader
  /*params::const_iterator it = params.find(params::gn_next_header);
  if (it != params.cend()) {
    p.gnNextHeader() = std::stoi(it->second);
  } else {
    p.gnNextHeader().set_to_omit();
  }
  // gnHeaderType
  it = params.find(params::gn_header_type);
  if (it != params.cend()) {
    p.gnHeaderType() = std::stoi(it->second);
  } else {
    p.gnHeaderType().set_to_omit();
  }
  // gnHeaderSubtype
  it = params.find(params::gn_header_sub_type);
  if (it != params.cend()) {
    p.gnHeaderSubtype() = std::stoi(it->second);
  } else {
    p.gnHeaderSubtype().set_to_omit();
  }
  // gnLifetime
  it = params.find(params::gn_lifetime);
  if (it != params.cend()) {
    p.gnLifetime() = std::stoi(it->second);
  } else {
    p.gnLifetime().set_to_omit();
  }
  // gnTrafficClass
  it = params.find(params::gn_traffic_class);
  if (it != params.cend()) {
    p.gnTrafficClass() = std::stoi(it->second);
  } else {
    p.gnTrafficClass().set_to_omit();
  }
  // btpDestinationPort
  it = params.find(params::btp_destination_port);
  if (it != params.cend()) {
    p.btpDestinationPort() = std::stoi(it->second);
  } else {
    p.btpDestinationPort().set_to_omit();
  }
  // btpInfo
  it = params.find(params::btp_info);
  if (it != params.cend()) {
    p.btpInfo() = std::stoi(it->second);
  } else {
    p.btpInfo().set_to_omit();
  }
  // ssp
  it = params.find(params::ssp);
  if (it != params.cend()) {
    OCTETSTRING os(it->second.length(), (const unsigned char *)(it->second.c_str()));
    p.ssp() = oct2bit(os);
  } else {
    p.ssp().set_to_omit();
  }
  // its_aid
  it = params.find(params::its_aid);
  if (it != params.cend()) {
    p.its__aid() = std::stoi(it->second);
  } else {
    p.its__aid().set_to_omit();
  }
  
  // Pass it to the ports if amy
  to_all_upper_ports(p, params);*/
}

mapem_spatem_layer_factory mapem_spatem_layer_factory::_f;
