/*!
 * \file      ConfigRsuSimulatorLayer.hh
 * \brief     Header file for ITS Configuration port protocol layer.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "t_layer.hh"
#include "ConfigRsuSimulatorCodec.hh"
#include "uppertester_geonetworking_codec.hh"
#include "uppertester_cam_codec.hh"
#include "uppertester_denm_codec.hh"

namespace ItsRSUsSimulator__TestSystem {
  class ConfigRsuSimulatorPort;
  class CfInitialize;
}

class ConfigRsuSimulatorLayer : public t_layer<ItsRSUsSimulator__TestSystem::ConfigRsuSimulatorPort> {
  params _params;
  ConfigRsuSimulatorCodec _codec;
  uppertester_cam_codec _codec_cam; // FIXME Enhance all codec to encode inputs messages also

public:
  ConfigRsuSimulatorLayer() : t_layer<ItsRSUsSimulator__TestSystem::ConfigRsuSimulatorPort>(), _params(), _codec(), _codec_cam() {};
  ConfigRsuSimulatorLayer(const std::string& p_type, const std::string& param);
  virtual ~ConfigRsuSimulatorLayer() {};

  void sendMsg(const ItsRSUsSimulator__TestSystem::CfInitialize&, params& params);
  void sendMsg(const LibItsGeoNetworking__TypesAndValues::UtGnResults& send_par, params& params);
  void sendMsg(const LibItsCam__TypesAndValues::UtCamResults& send_par, params& params);
  void sendMsg(const LibItsDenm__TypesAndValues::UtDenmResults& send_par, params& params);
  
  virtual void send_data(OCTETSTRING& data, params& params);
  virtual void receive_data(OCTETSTRING& data, params& params);

private:
  int process_utinitialize_data(const OCTETSTRING& data, params& params);
  int process_ut_cam_changespeed_data(const OCTETSTRING& data, params& params);
  int process_ut_geonetworking_trigger(const OCTETSTRING& data, params& params);

}; // End of class ConfigRsuSimulatorLayer
