/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIBodyEncoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.EncodingOptions;
import com.siemens.ct.exi.attributes.AttributeList;
import com.siemens.ct.exi.context.EncoderContext;
import com.siemens.ct.exi.context.EncoderContextImpl;
import com.siemens.ct.exi.context.EvolvingUriContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.context.UriContext;
import com.siemens.ct.exi.core.AbstractEXIBodyCoder;
import com.siemens.ct.exi.core.EXIHeaderEncoder;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.strings.StringCoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammars.event.Attribute;
import com.siemens.ct.exi.grammars.event.AttributeNS;
import com.siemens.ct.exi.grammars.event.DatatypeEvent;
import com.siemens.ct.exi.grammars.event.EventType;
import com.siemens.ct.exi.grammars.event.StartElement;
import com.siemens.ct.exi.grammars.event.StartElementNS;
import com.siemens.ct.exi.grammars.grammar.Grammar;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedFirstStartTagGrammar;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedGrammar;
import com.siemens.ct.exi.grammars.production.Production;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltIn;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.types.TypeEncoder;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.util.xml.QNameUtilities;
import com.siemens.ct.exi.values.QNameValue;
import com.siemens.ct.exi.values.StringValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public abstract class AbstractEXIBodyEncoder
extends AbstractEXIBodyCoder
implements EXIBodyEncoder {
    protected final EXIHeaderEncoder exiHeader = new EXIHeaderEncoder();
    protected String sePrefix = null;
    protected EncoderChannel channel;
    protected final TypeEncoder typeEncoder;
    protected final EncodingOptions encodingOptions;
    protected final EncoderContext encoderContext;
    protected final boolean grammarLearningDisabled;

    public AbstractEXIBodyEncoder(EXIFactory exiFactory) throws EXIException {
        super(exiFactory);
        this.typeEncoder = exiFactory.createTypeEncoder();
        this.encodingOptions = exiFactory.getEncodingOptions();
        this.grammarLearningDisabled = exiFactory.isGrammarLearningDisabled();
        this.encoderContext = new EncoderContextImpl(exiFactory.getGrammars().getGrammarContext(), exiFactory.createStringEncoder());
    }

    protected void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.encoderContext.clear();
    }

    public void flush() throws IOException {
        this.channel.flush();
    }

    protected void writeString(String text) throws IOException {
        this.channel.encodeString(text);
    }

    protected boolean isTypeValid(Datatype datatype, Value value) {
        return this.typeEncoder.isValid(datatype, value);
    }

    protected abstract void writeValue(QNameContext var1) throws IOException;

    protected void encode1stLevelEventCode(int pos) throws IOException {
        int codeLength = this.getCurrentGrammar().get1stLevelEventCodeLength(this.fidelityOptions);
        if (codeLength > 0) {
            this.channel.encodeNBitUnsignedInteger(pos, codeLength);
        }
    }

    protected void encode2ndLevelEventCode(int pos) throws IOException {
        Grammar currentGrammar = this.getCurrentGrammar();
        this.channel.encodeNBitUnsignedInteger(currentGrammar.getNumberOfEvents(), currentGrammar.get1stLevelEventCodeLength(this.fidelityOptions));
        int ch2 = currentGrammar.get2ndLevelCharacteristics(this.fidelityOptions);
        assert (pos < ch2);
        this.channel.encodeNBitUnsignedInteger(pos, MethodsBag.getCodingLength(ch2));
    }

    protected void encode3rdLevelEventCode(int pos) throws IOException {
        Grammar currentGrammar = this.getCurrentGrammar();
        this.channel.encodeNBitUnsignedInteger(currentGrammar.getNumberOfEvents(), currentGrammar.get1stLevelEventCodeLength(this.fidelityOptions));
        int ch2 = currentGrammar.get2ndLevelCharacteristics(this.fidelityOptions);
        int ec2 = ch2 > 0 ? ch2 - 1 : 0;
        this.channel.encodeNBitUnsignedInteger(ec2, MethodsBag.getCodingLength(ch2));
        int ch3 = currentGrammar.get3rdLevelCharacteristics(this.fidelityOptions);
        assert (pos < ch3);
        this.channel.encodeNBitUnsignedInteger(pos, MethodsBag.getCodingLength(ch3));
    }

    public void encodeStartDocument() throws EXIException, IOException {
        if (this.channel == null) {
            throw new EXIException("No valid EXI OutputStream set for encoding. Please use setOutput( ... )");
        }
        this.initForEachRun();
        Production ei = this.getCurrentGrammar().getProduction(EventType.START_DOCUMENT);
        if (ei == null) {
            throw new EXIException("No EXI Event found for startDocument");
        }
        this.updateCurrentRule(ei.getNextGrammar());
    }

    public void encodeEndDocument() throws EXIException, IOException {
        Production ei = this.getCurrentGrammar().getProduction(EventType.END_DOCUMENT);
        if (ei == null) {
            throw new EXIException("No EXI Event found for endDocument");
        }
        this.encode1stLevelEventCode(ei.getEventCode());
    }

    public void encodeStartElement(QName se) throws EXIException, IOException {
        this.encodeStartElement(se.getNamespaceURI(), se.getLocalPart(), se.getPrefix());
    }

    public void encodeStartElement(String uri, String localName, String prefix) throws EXIException, IOException {
        Grammar updContextRule;
        StartElement nextSE;
        this.sePrefix = prefix;
        Grammar currentGrammar = this.getCurrentGrammar();
        Production ei = currentGrammar.getStartElementProduction(uri, localName);
        if (ei != null) {
            assert (ei.getEvent().isEventType(EventType.START_ELEMENT));
            this.encode1stLevelEventCode(ei.getEventCode());
            nextSE = (StartElement)ei.getEvent();
            if (this.preservePrefix) {
                this.encoderContext.encodeQNamePrefix(nextSE.getQNameContext(), prefix, this.channel);
            }
            updContextRule = ei.getNextGrammar();
        } else {
            ei = currentGrammar.getStartElementNSProduction(uri);
            if (ei != null) {
                assert (ei.getEvent().isEventType(EventType.START_ELEMENT_NS));
                this.encode1stLevelEventCode(ei.getEventCode());
                StartElementNS seNS = (StartElementNS)ei.getEvent();
                EvolvingUriContext uc = this.encoderContext.getUriContext(seNS.getNamespaceUriID());
                QNameContext qnc = this.encoderContext.encodeLocalName(localName, uc, this.channel);
                if (this.preservePrefix) {
                    this.encoderContext.encodeQNamePrefix(qnc, prefix, this.channel);
                }
                updContextRule = ei.getNextGrammar();
                nextSE = this.encoderContext.getGlobalStartElement(qnc);
            } else {
                ei = currentGrammar.getProduction(EventType.START_ELEMENT_GENERIC);
                if (ei != null) {
                    assert (ei.getEvent().isEventType(EventType.START_ELEMENT_GENERIC));
                    this.encode1stLevelEventCode(ei.getEventCode());
                    updContextRule = ei.getNextGrammar();
                } else {
                    int ecSEundeclared = currentGrammar.get2ndLevelEventCode(EventType.START_ELEMENT_GENERIC_UNDECLARED, this.fidelityOptions);
                    if (ecSEundeclared == -1) {
                        throw new EXIException("Unexpected SE {" + uri + "}" + localName + ", " + this.exiFactory.toString());
                    }
                    if (this.limitGrammarLearning()) {
                        currentGrammar = this.getCurrentGrammar();
                        ei = currentGrammar.getProduction(EventType.START_ELEMENT_GENERIC);
                        assert (ei != null);
                        this.encode1stLevelEventCode(ei.getEventCode());
                        updContextRule = ei.getNextGrammar();
                    } else {
                        this.encode2ndLevelEventCode(ecSEundeclared);
                        updContextRule = currentGrammar.getElementContentGrammar();
                    }
                }
                QNameContext qnc = this.encoderContext.encodeQName(uri, localName, this.channel);
                if (this.preservePrefix) {
                    this.encoderContext.encodeQNamePrefix(qnc, prefix, this.channel);
                }
                nextSE = this.encoderContext.getGlobalStartElement(qnc);
                currentGrammar.learnStartElement(nextSE);
            }
        }
        this.pushElement(updContextRule, nextSE);
    }

    private boolean limitGrammarLearning() throws EXIException, IOException {
        if (this.grammarLearningDisabled && this.grammar.isSchemaInformed() && !this.getCurrentGrammar().isSchemaInformed()) {
            EvolvingUriContext euc;
            int numberOfPrefixes;
            String pfx = null;
            if (this.preservePrefix && (numberOfPrefixes = (euc = this.encoderContext.getUriContext(3)).getNumberOfPrefixes()) > 0) {
                pfx = euc.getPrefix(0);
            }
            QNameValue type = new QNameValue("http://www.w3.org/2001/XMLSchema", "anyType", pfx);
            this.encodeAttributeXsiType(type, pfx, true);
            return true;
        }
        return false;
    }

    public void encodeNamespaceDeclaration(String uri, String prefix) throws EXIException, IOException {
        this.declarePrefix(prefix, uri);
        if (this.preservePrefix) {
            assert (this.sePrefix != null);
            Grammar currentGrammar = this.getCurrentGrammar();
            int ec2 = currentGrammar.get2ndLevelEventCode(EventType.NAMESPACE_DECLARATION, this.fidelityOptions);
            assert (currentGrammar.get2ndLevelEventType(ec2, this.fidelityOptions) == EventType.NAMESPACE_DECLARATION);
            this.encode2ndLevelEventCode(ec2);
            EvolvingUriContext euc = this.encoderContext.encodeUri(uri, this.channel);
            this.encoderContext.encodeNamespacePrefix(euc, prefix, this.channel);
            this.channel.encodeBoolean(prefix.equals(this.sePrefix));
        }
    }

    public void encodeEndElement() throws EXIException, IOException {
        Grammar currentGrammar = this.getCurrentGrammar();
        Production ei = currentGrammar.getProduction(EventType.END_ELEMENT);
        if (ei != null) {
            this.encode1stLevelEventCode(ei.getEventCode());
        } else {
            ei = currentGrammar.getProduction(EventType.CHARACTERS);
            if (ei != null) {
                BuiltInType bit = ((DatatypeEvent)ei.getEvent()).getDatatype().getBuiltInType();
                switch (bit) {
                    case BINARY_BASE64: 
                    case BINARY_HEX: 
                    case STRING: 
                    case RCS_STRING: 
                    case LIST: {
                        ei = ei.getNextGrammar().getProduction(EventType.END_ELEMENT);
                        if (ei == null) break;
                        this.encodeCharactersForce(StringCoder.EMPTY_STRING_VALUE);
                        break;
                    }
                    default: {
                        ei = null;
                    }
                }
            }
            if (ei != null) {
                this.encode1stLevelEventCode(ei.getEventCode());
            } else {
                int ecEEundeclared = currentGrammar.get2ndLevelEventCode(EventType.END_ELEMENT_UNDECLARED, this.fidelityOptions);
                if (ecEEundeclared == -1) {
                    throw new EXIException("Unexpected EE {" + this.getElementContext() + ", " + this.exiFactory.toString());
                }
                if (this.limitGrammarLearning()) {
                    currentGrammar = this.getCurrentGrammar();
                    ei = currentGrammar.getProduction(EventType.END_ELEMENT);
                    assert (ei != null);
                    this.encode1stLevelEventCode(ei.getEventCode());
                } else {
                    this.encode2ndLevelEventCode(ecEEundeclared);
                    currentGrammar.learnEndElement();
                }
            }
        }
        this.popElement();
    }

    public void encodeAttributeList(AttributeList attributes) throws EXIException, IOException {
        int i = 0;
        while (i < attributes.getNumberOfNamespaceDeclarations()) {
            NamespaceDeclaration ns = attributes.getNamespaceDeclaration(i);
            this.encodeNamespaceDeclaration(ns.namespaceURI, ns.prefix);
            ++i;
        }
        if (attributes.hasXsiType()) {
            this.encodeAttributeXsiType(new StringValue(attributes.getXsiTypeRaw()), attributes.getXsiTypePrefix());
        }
        if (attributes.hasXsiNil()) {
            this.encodeAttributeXsiNil(new StringValue(attributes.getXsiNil()), attributes.getXsiNilPrefix());
        }
        i = 0;
        while (i < attributes.getNumberOfAttributes()) {
            this.encodeAttribute(attributes.getAttributeURI(i), attributes.getAttributeLocalName(i), attributes.getAttributePrefix(i), new StringValue(attributes.getAttributeValue(i)));
            ++i;
        }
    }

    public void encodeAttributeXsiType(Value type, String pfx) throws EXIException, IOException {
        this.encodeAttributeXsiType(type, pfx, false);
    }

    private void encodeAttributeXsiType(Value type, String pfx, boolean force2ndLevelProduction) throws EXIException, IOException {
        QNameContext qncType;
        String qnameLocalName;
        String qnamePrefix;
        String qnameURI;
        if (type instanceof QNameValue) {
            QNameValue qv = (QNameValue)type;
            qnameURI = qv.getNamespaceUri();
            qnamePrefix = qv.getPrefix();
            qnameLocalName = qv.getLocalName();
        } else {
            String sType = type.toString();
            qnamePrefix = QNameUtilities.getPrefixPart(sType);
            qnameURI = this.getURI(qnamePrefix);
            if (qnameURI == null) {
                qnameURI = "";
                qnameLocalName = sType;
            } else {
                qnameLocalName = QNameUtilities.getLocalPart(sType);
            }
        }
        Grammar currentGrammar = this.getCurrentGrammar();
        int ec2 = currentGrammar.get2ndLevelEventCode(EventType.ATTRIBUTE_XSI_TYPE, this.fidelityOptions);
        if (ec2 != -1) {
            assert (currentGrammar.get2ndLevelEventType(ec2, this.fidelityOptions) == EventType.ATTRIBUTE_XSI_TYPE);
            this.encode2ndLevelEventCode(ec2);
            if (this.preservePrefix) {
                this.encoderContext.encodeQNamePrefix(this.encoderContext.getXsiTypeContext(), pfx, this.channel);
            }
        } else {
            Production ei = force2ndLevelProduction ? null : currentGrammar.getAttributeProduction("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (ei != null) {
                this.encode1stLevelEventCode(ei.getEventCode());
            } else {
                QNameContext qncType2;
                if (!force2ndLevelProduction) {
                    ei = currentGrammar.getProduction(EventType.ATTRIBUTE_GENERIC);
                }
                if (ei != null) {
                    this.encode1stLevelEventCode(ei.getEventCode());
                } else {
                    ec2 = currentGrammar.get2ndLevelEventCode(EventType.ATTRIBUTE_GENERIC_UNDECLARED, this.fidelityOptions);
                    if (ec2 != -1) {
                        this.encode2ndLevelEventCode(ec2);
                        qncType2 = this.encoderContext.getXsiTypeContext();
                        currentGrammar.learnAttribute(new Attribute(qncType2));
                    } else {
                        throw new EXIException("TypeCast " + type + " not encodable!");
                    }
                }
                qncType2 = this.encoderContext.getXsiTypeContext();
                this.encoderContext.encodeQName(qncType2.getNamespaceUri(), qncType2.getLocalName(), this.channel);
                if (this.preservePrefix) {
                    this.encoderContext.encodeQNamePrefix(qncType2, pfx, this.channel);
                }
            }
        }
        if (this.preserveLexicalValues) {
            if (qnamePrefix.length() > 0 && !this.preservePrefix) {
                throw new EXIException("[EXI] xsi:type='" + type + "' not encodable. Preserve lexicalValues requires prefixes preserved as well!");
            }
            this.typeEncoder.isValid(BuiltIn.DEFAULT_DATATYPE, type);
            this.typeEncoder.writeValue(this.encoderContext, this.encoderContext.getXsiTypeContext(), this.channel);
            EvolvingUriContext uc = this.encoderContext.getUriContext(qnameURI);
            qncType = uc != null ? uc.getQNameContext(qnameLocalName) : null;
        } else {
            qncType = this.encoderContext.encodeQName(qnameURI, qnameLocalName, this.channel);
            if (this.preservePrefix) {
                this.encoderContext.encodeQNamePrefix(qncType, qnamePrefix, this.channel);
            }
        }
        if (qncType != null && qncType.getTypeGrammar() != null) {
            this.updateCurrentRule(qncType.getTypeGrammar());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeAttributeXsiNil(Value nil, String pfx) throws EXIException, IOException {
        Grammar currentGrammar = this.getCurrentGrammar();
        if (currentGrammar.isSchemaInformed()) {
            SchemaInformedGrammar siCurrentRule = (SchemaInformedGrammar)currentGrammar;
            if (this.booleanDatatype.isValid(nil)) {
                if (!(this.preserveLexicalValues || this.booleanDatatype.getBoolean() || this.encodingOptions.isOptionEnabled("INCLUDE_INSIGNIFICANT_XSI_NIL"))) {
                    return;
                }
                int ec2 = siCurrentRule.get2ndLevelEventCode(EventType.ATTRIBUTE_XSI_NIL, this.fidelityOptions);
                if (ec2 != -1) {
                    this.encode2ndLevelEventCode(ec2);
                    if (this.preservePrefix) {
                        this.encoderContext.encodeQNamePrefix(this.encoderContext.getXsiNilContext(), pfx, this.channel);
                    }
                    if (this.preserveLexicalValues) {
                        this.typeEncoder.isValid(this.booleanDatatype, nil);
                        this.typeEncoder.writeValue(this.encoderContext, this.encoderContext.getXsiTypeContext(), this.channel);
                    } else {
                        this.booleanDatatype.writeValue(this.encoderContext, null, this.channel);
                    }
                    if (!this.booleanDatatype.getBoolean()) return;
                    this.updateCurrentRule(((SchemaInformedFirstStartTagGrammar)siCurrentRule).getTypeEmpty());
                    return;
                } else {
                    Production ei = currentGrammar.getProduction(EventType.ATTRIBUTE_GENERIC);
                    if (ei == null) throw new EXIException("Attribute xsi=nil='" + nil + "' cannot be encoded!");
                    this.encode1stLevelEventCode(ei.getEventCode());
                    EvolvingUriContext euc = this.encoderContext.encodeUri("http://www.w3.org/2001/XMLSchema-instance", this.channel);
                    this.encoderContext.encodeLocalName("nil", euc, this.channel);
                    if (this.preservePrefix) {
                        this.encoderContext.encodeQNamePrefix(this.encoderContext.getXsiNilContext(), pfx, this.channel);
                    }
                    if (this.preserveLexicalValues) {
                        this.typeEncoder.isValid(this.booleanDatatype, nil);
                        this.typeEncoder.writeValue(this.encoderContext, this.encoderContext.getXsiNilContext(), this.channel);
                    } else {
                        this.booleanDatatype.writeValue(this.encoderContext, null, this.channel);
                    }
                    if (!this.booleanDatatype.getBoolean()) return;
                    this.updateCurrentRule(((SchemaInformedFirstStartTagGrammar)siCurrentRule).getTypeEmpty());
                }
                return;
            } else {
                this.encodeSchemaInvalidAttributeEventCode(currentGrammar.getNumberOfDeclaredAttributes());
                EvolvingUriContext euc = this.encoderContext.encodeUri("http://www.w3.org/2001/XMLSchema-instance", this.channel);
                this.encoderContext.encodeLocalName("nil", euc, this.channel);
                if (this.preservePrefix) {
                    this.encoderContext.encodeQNamePrefix(this.encoderContext.getXsiNilContext(), pfx, this.channel);
                }
                Datatype datatype = BuiltIn.DEFAULT_DATATYPE;
                this.isTypeValid(datatype, nil);
                this.writeValue(this.encoderContext.getXsiTypeContext());
            }
            return;
        } else {
            this.encodeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", pfx, nil);
        }
    }

    protected void encodeSchemaInvalidAttributeEventCode(int eventCode3) throws IOException {
        Grammar currentGrammar = this.getCurrentGrammar();
        int ec2ATdeviated = currentGrammar.get2ndLevelEventCode(EventType.ATTRIBUTE_INVALID_VALUE, this.fidelityOptions);
        this.encode2ndLevelEventCode(ec2ATdeviated);
        this.channel.encodeNBitUnsignedInteger(eventCode3, MethodsBag.getCodingLength(currentGrammar.getNumberOfDeclaredAttributes() + 1));
    }

    public void encodeAttribute(QName at, Value value) throws EXIException, IOException {
        this.encodeAttribute(at.getNamespaceURI(), at.getLocalPart(), at.getPrefix(), value);
    }

    public void encodeAttribute(String uri, String localName, String prefix, Value value) throws EXIException, IOException {
        Grammar next;
        QNameContext qnc;
        Grammar currentGrammar = this.getCurrentGrammar();
        Production ei = currentGrammar.getAttributeProduction(uri, localName);
        if (ei != null) {
            Attribute at = (Attribute)ei.getEvent();
            qnc = at.getQNameContext();
            if (this.isTypeValid(at.getDatatype(), value)) {
                this.encode1stLevelEventCode(ei.getEventCode());
            } else {
                int eventCode3 = ei.getEventCode() - currentGrammar.getLeastAttributeEventCode();
                this.encodeSchemaInvalidAttributeEventCode(eventCode3);
                this.isTypeValid(BuiltIn.DEFAULT_DATATYPE, value);
            }
            next = ei.getNextGrammar();
        } else {
            Attribute globalAT;
            if (this.limitGrammarLearning()) {
                currentGrammar = this.getCurrentGrammar();
            }
            if ((ei = currentGrammar.getAttributeNSProduction(uri)) == null) {
                ei = currentGrammar.getProduction(EventType.ATTRIBUTE_GENERIC);
            }
            if (currentGrammar.isSchemaInformed() && (globalAT = this.getGlobalAttribute(uri, localName)) != null) {
                assert (ei != null);
                if (this.isTypeValid(globalAT.getDatatype(), value)) {
                    if (ei == null) {
                        this.encodeAttributeEventCodeUndeclared(currentGrammar, localName);
                    } else {
                        this.encode1stLevelEventCode(ei.getEventCode());
                    }
                } else {
                    this.encodeSchemaInvalidAttributeEventCode(currentGrammar.getNumberOfDeclaredAttributes());
                    this.isTypeValid(BuiltIn.DEFAULT_DATATYPE, value);
                }
                if (ei == null || ei.getEvent().isEventType(EventType.ATTRIBUTE_GENERIC)) {
                    qnc = this.encoderContext.encodeQName(uri, localName, this.channel);
                    next = ei == null ? currentGrammar : ei.getNextGrammar();
                } else {
                    AttributeNS atNS = (AttributeNS)ei.getEvent();
                    EvolvingUriContext uc = this.encoderContext.getUriContext(atNS.getNamespaceUriID());
                    qnc = this.encoderContext.encodeLocalName(localName, uc, this.channel);
                    next = ei.getNextGrammar();
                }
            } else {
                this.isTypeValid(BuiltIn.DEFAULT_DATATYPE, value);
                if (ei == null) {
                    qnc = this.encodeUndeclaredAT(currentGrammar, uri, localName);
                    next = currentGrammar;
                } else {
                    qnc = this.encodeDeclaredAT(ei, uri, localName);
                    next = ei.getNextGrammar();
                }
            }
        }
        assert (qnc != null);
        if (this.preservePrefix) {
            this.encoderContext.encodeQNamePrefix(qnc, prefix, this.channel);
        }
        this.writeValue(qnc);
        assert (next != null);
        this.updateCurrentRule(next);
    }

    private void encodeAttributeEventCodeUndeclared(Grammar currentGrammar, String localName) throws IOException, EXIException {
        int ecATundeclared = currentGrammar.get2ndLevelEventCode(EventType.ATTRIBUTE_GENERIC_UNDECLARED, this.fidelityOptions);
        if (ecATundeclared == -1) {
            assert (this.fidelityOptions.isStrict());
            throw new EXIException("Attribute '" + localName + "' cannot be encoded!");
        }
        assert (ecATundeclared != -1);
        this.encode2ndLevelEventCode(ecATundeclared);
    }

    private QNameContext encodeDeclaredAT(Production ei, String uri, String localName) throws IOException {
        QNameContext qnc;
        this.encode1stLevelEventCode(ei.getEventCode());
        if (ei.getEvent().isEventType(EventType.ATTRIBUTE_NS)) {
            AttributeNS atNS = (AttributeNS)ei.getEvent();
            EvolvingUriContext uc = this.encoderContext.getUriContext(atNS.getNamespaceUriID());
            qnc = this.encoderContext.encodeLocalName(localName, uc, this.channel);
        } else {
            qnc = this.encoderContext.encodeQName(uri, localName, this.channel);
        }
        return qnc;
    }

    private QNameContext encodeUndeclaredAT(Grammar currentGrammar, String uri, String localName) throws EXIException, IOException {
        this.encodeAttributeEventCodeUndeclared(currentGrammar, localName);
        QNameContext qnc = this.encoderContext.encodeQName(uri, localName, this.channel);
        currentGrammar.learnAttribute(new Attribute(qnc));
        return qnc;
    }

    protected Attribute getGlobalAttribute(String uri, String localName) {
        EvolvingUriContext uc = this.encoderContext.getUriContext(uri);
        if (uc != null) {
            return this.getGlobalAttribute(uc, localName);
        }
        return null;
    }

    protected Attribute getGlobalAttribute(UriContext uc, String localName) {
        assert (uc != null);
        QNameContext qnc = uc.getQNameContext(localName);
        if (qnc != null) {
            return qnc.getGlobalAttribute();
        }
        return null;
    }

    public void encodeCharacters(Value chars) throws EXIException, IOException {
        String tchars;
        if (!this.preserveLexicalValues && (tchars = chars.toString().trim()).length() == 0) {
            return;
        }
        this.encodeCharactersForce(chars);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeCharactersForce(Value chars) throws EXIException, IOException {
        Grammar currentGrammar = this.getCurrentGrammar();
        Production ei = currentGrammar.getProduction(EventType.CHARACTERS);
        if (ei != null && this.isTypeValid(((DatatypeEvent)ei.getEvent()).getDatatype(), chars)) {
            this.encode1stLevelEventCode(ei.getEventCode());
            this.writeValue(this.getElementContext().qnameContext);
            this.updateCurrentRule(ei.getNextGrammar());
            return;
        } else {
            ei = currentGrammar.getProduction(EventType.CHARACTERS_GENERIC);
            if (ei != null) {
                this.encode1stLevelEventCode(ei.getEventCode());
                this.isTypeValid(BuiltIn.DEFAULT_DATATYPE, chars);
                this.writeValue(this.getElementContext().qnameContext);
                this.updateCurrentRule(ei.getNextGrammar());
                return;
            } else {
                int ecCHundeclared = currentGrammar.get2ndLevelEventCode(EventType.CHARACTERS_GENERIC_UNDECLARED, this.fidelityOptions);
                if (ecCHundeclared == -1) {
                    if (this.exiFactory.isFragment()) {
                        this.throwWarning("Skip CH: '" + chars + "'");
                        return;
                    } else {
                        if (!this.fidelityOptions.isStrict() || chars.toString().trim().length() != 0) throw new EXIException("Characters '" + chars + "' cannot be encoded!");
                        this.throwWarning("Skip CH: '" + chars + "'");
                    }
                    return;
                } else {
                    Grammar updContextRule;
                    if (this.limitGrammarLearning()) {
                        currentGrammar = this.getCurrentGrammar();
                        ei = currentGrammar.getProduction(EventType.CHARACTERS_GENERIC);
                        assert (ei != null);
                        this.encode1stLevelEventCode(ei.getEventCode());
                        updContextRule = ei.getNextGrammar();
                    } else {
                        this.encode2ndLevelEventCode(ecCHundeclared);
                        currentGrammar.learnCharacters();
                        updContextRule = currentGrammar.getElementContentGrammar();
                    }
                    this.isTypeValid(BuiltIn.DEFAULT_DATATYPE, chars);
                    this.writeValue(this.getElementContext().qnameContext);
                    this.updateCurrentRule(updContextRule);
                }
            }
        }
    }

    public void encodeDocType(String name, String publicID, String systemID, String text) throws EXIException, IOException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            int ec2 = this.getCurrentGrammar().get2ndLevelEventCode(EventType.DOC_TYPE, this.fidelityOptions);
            this.encode2ndLevelEventCode(ec2);
            this.writeString(name);
            this.writeString(publicID);
            this.writeString(systemID);
            this.writeString(text);
        }
    }

    public void encodeEntityReference(String name) throws EXIException, IOException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            Grammar currentGrammar = this.getCurrentGrammar();
            int ec2 = currentGrammar.get2ndLevelEventCode(EventType.ENTITY_REFERENCE, this.fidelityOptions);
            this.encode2ndLevelEventCode(ec2);
            this.writeString(name);
            this.updateCurrentRule(currentGrammar.getElementContentGrammar());
        }
    }

    public void encodeComment(char[] ch, int start, int length) throws EXIException, IOException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS")) {
            Grammar currentGrammar = this.getCurrentGrammar();
            int ec3 = currentGrammar.get3rdLevelEventCode(EventType.COMMENT, this.fidelityOptions);
            this.encode3rdLevelEventCode(ec3);
            this.writeString(new String(ch, start, length));
            this.updateCurrentRule(currentGrammar.getElementContentGrammar());
        }
    }

    public void encodeProcessingInstruction(String target, String data) throws EXIException, IOException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_PIS")) {
            Grammar currentGrammar = this.getCurrentGrammar();
            int ec3 = currentGrammar.get3rdLevelEventCode(EventType.PROCESSING_INSTRUCTION, this.fidelityOptions);
            this.encode3rdLevelEventCode(ec3);
            this.writeString(target);
            this.writeString(data);
            this.updateCurrentRule(currentGrammar.getElementContentGrammar());
        }
    }
}

