/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIBodyDecoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.context.DecoderContext;
import com.siemens.ct.exi.context.DecoderContextImpl;
import com.siemens.ct.exi.context.EvolvingUriContext;
import com.siemens.ct.exi.context.GrammarContext;
import com.siemens.ct.exi.context.GrammarUriContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.core.AbstractEXIBodyCoder;
import com.siemens.ct.exi.core.container.DocType;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import com.siemens.ct.exi.core.container.ProcessingInstruction;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammars.event.Attribute;
import com.siemens.ct.exi.grammars.event.AttributeNS;
import com.siemens.ct.exi.grammars.event.Characters;
import com.siemens.ct.exi.grammars.event.Event;
import com.siemens.ct.exi.grammars.event.EventType;
import com.siemens.ct.exi.grammars.event.StartElement;
import com.siemens.ct.exi.grammars.event.StartElementNS;
import com.siemens.ct.exi.grammars.grammar.Grammar;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedFirstStartTagGrammar;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedGrammar;
import com.siemens.ct.exi.grammars.production.Production;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.types.BuiltIn;
import com.siemens.ct.exi.types.TypeDecoder;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.util.xml.QNameUtilities;
import com.siemens.ct.exi.values.BooleanValue;
import com.siemens.ct.exi.values.QNameValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;

public abstract class AbstractEXIBodyDecoder
extends AbstractEXIBodyCoder
implements EXIBodyDecoder {
    protected Event nextEvent;
    protected Grammar nextGrammar;
    protected EventType nextEventType;
    protected DecoderChannel channel;
    protected final int numberOfUriContexts;
    protected final TypeDecoder typeDecoder;
    protected QNameContext attributeQNameContext;
    protected String attributePrefix;
    protected Value attributeValue;
    protected final DecoderContext decoderContext;

    public AbstractEXIBodyDecoder(EXIFactory exiFactory) throws EXIException {
        super(exiFactory);
        this.typeDecoder = exiFactory.createTypeDecoder();
        this.decoderContext = new DecoderContextImpl(exiFactory.getGrammars().getGrammarContext(), exiFactory.createStringDecoder());
        this.numberOfUriContexts = this.grammar.getGrammarContext().getNumberOfGrammarUriContexts();
    }

    protected final void pushElement(Grammar updContextGrammar, StartElement se) {
        super.pushElement(updContextGrammar, se);
        if (!this.preservePrefix && this.elementContextStackIndex == 1) {
            GrammarContext gc = this.grammar.getGrammarContext();
            int i = 2;
            while (i < gc.getNumberOfGrammarUriContexts()) {
                GrammarUriContext guc = gc.getGrammarUriContext(i);
                String pfx = guc.getDefaultPrefix();
                this.declarePrefix(pfx, guc.getNamespaceUri());
                ++i;
            }
        }
    }

    protected void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.decoderContext.clear();
    }

    protected final EventType decodeEventCode() throws EXIException, IOException {
        int ec;
        Grammar currentGrammar = this.getCurrentGrammar();
        int codeLength = currentGrammar.get1stLevelEventCodeLength(this.fidelityOptions);
        int n = ec = codeLength == 0 ? 0 : this.channel.decodeNBitUnsignedInteger(codeLength);
        assert (ec >= 0);
        if (ec < currentGrammar.getNumberOfEvents()) {
            Production ei = currentGrammar.getProduction(ec);
            this.nextEvent = ei.getEvent();
            this.nextGrammar = ei.getNextGrammar();
            this.nextEventType = this.nextEvent.getEventType();
        } else {
            int ec2 = this.decode2ndLevelEventCode();
            if (ec2 == -1) {
                int ec3 = this.decode3rdLevelEventCode();
                this.nextEventType = currentGrammar.get3rdLevelEventType(ec3, this.fidelityOptions);
                this.nextEvent = null;
                this.nextGrammar = null;
            } else {
                this.nextEventType = currentGrammar.get2ndLevelEventType(ec2, this.fidelityOptions);
                if (this.nextEventType == EventType.ATTRIBUTE_INVALID_VALUE) {
                    this.updateInvalidValueAttribute(ec);
                } else {
                    this.nextEvent = null;
                    this.nextGrammar = null;
                }
            }
        }
        return this.nextEventType;
    }

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    public String getAttributeQNameAsString() {
        if (this.preservePrefix) {
            return QNameUtilities.getQualifiedName(this.attributeQNameContext.getLocalName(), this.attributePrefix);
        }
        return this.attributeQNameContext.getDefaultQNameAsString();
    }

    public Value getAttributeValue() {
        return this.attributeValue;
    }

    protected void updateInvalidValueAttribute(int ec) throws EXIException {
        int ec3AT;
        SchemaInformedGrammar sir = (SchemaInformedGrammar)this.getCurrentGrammar();
        try {
            ec3AT = this.channel.decodeNBitUnsignedInteger(MethodsBag.getCodingLength(sir.getNumberOfDeclaredAttributes() + 1));
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
        if (ec3AT < sir.getNumberOfDeclaredAttributes()) {
            ec = ec3AT + sir.getLeastAttributeEventCode();
            Production ei = sir.getProduction(ec);
            this.nextEvent = ei.getEvent();
            this.nextGrammar = ei.getNextGrammar();
        } else if (ec3AT == sir.getNumberOfDeclaredAttributes()) {
            this.nextEventType = EventType.ATTRIBUTE_ANY_INVALID_VALUE;
        } else {
            throw new EXIException("Error occured while decoding deviated attribute");
        }
    }

    protected int decode2ndLevelEventCode() throws EXIException, IOException {
        Grammar currentGrammar = this.getCurrentGrammar();
        int ch2 = currentGrammar.get2ndLevelCharacteristics(this.fidelityOptions);
        int level2 = this.channel.decodeNBitUnsignedInteger(MethodsBag.getCodingLength(ch2));
        if (currentGrammar.get3rdLevelCharacteristics(this.fidelityOptions) > 0) {
            return level2 < ch2 - 1 ? level2 : -1;
        }
        return level2 < ch2 ? level2 : -1;
    }

    protected int decode3rdLevelEventCode() throws EXIException, IOException {
        int ch3 = this.getCurrentGrammar().get3rdLevelCharacteristics(this.fidelityOptions);
        return this.channel.decodeNBitUnsignedInteger(MethodsBag.getCodingLength(ch3));
    }

    protected final void decodeStartDocumentStructure() throws EXIException {
        this.updateCurrentRule(this.getCurrentGrammar().getProduction(0).getNextGrammar());
    }

    protected final void decodeEndDocumentStructure() throws EXIException, IOException {
    }

    protected final QNameContext decodeStartElementStructure() throws IOException {
        assert (this.nextEventType == EventType.START_ELEMENT);
        StartElement se = (StartElement)this.nextEvent;
        this.pushElement(this.nextGrammar, se);
        QNameContext qnc = se.getQNameContext();
        this.handleElementPrefix(qnc);
        return qnc;
    }

    protected final QNameContext decodeStartElementNSStructure() throws IOException {
        assert (this.nextEventType == EventType.START_ELEMENT_NS);
        StartElementNS seNS = (StartElementNS)this.nextEvent;
        EvolvingUriContext uc = this.decoderContext.getUriContext(seNS.getNamespaceUriID());
        QNameContext qnc = this.decoderContext.decodeLocalName(uc, this.channel);
        StartElement nextSE = this.decoderContext.getGlobalStartElement(qnc);
        this.pushElement(this.nextGrammar, nextSE);
        this.handleElementPrefix(qnc);
        return qnc;
    }

    protected final QNameContext decodeStartElementGenericStructure() throws IOException {
        assert (this.nextEventType == EventType.START_ELEMENT_GENERIC);
        QNameContext qnc = this.decoderContext.decodeQName(this.channel);
        StartElement nextSE = this.decoderContext.getGlobalStartElement(qnc);
        this.getCurrentGrammar().learnStartElement(nextSE);
        this.pushElement(this.nextGrammar.getElementContentGrammar(), nextSE);
        this.handleElementPrefix(qnc);
        return qnc;
    }

    protected final QNameContext decodeStartElementGenericUndeclaredStructure() throws IOException {
        assert (this.nextEventType == EventType.START_ELEMENT_GENERIC_UNDECLARED);
        QNameContext qnc = this.decoderContext.decodeQName(this.channel);
        StartElement nextSE = this.decoderContext.getGlobalStartElement(qnc);
        Grammar currentGrammar = this.getCurrentGrammar();
        currentGrammar.learnStartElement(nextSE);
        this.pushElement(currentGrammar.getElementContentGrammar(), nextSE);
        this.handleElementPrefix(qnc);
        return qnc;
    }

    protected final AbstractEXIBodyCoder.ElementContext decodeEndElementStructure() throws EXIException, IOException {
        return this.popElement();
    }

    protected final AbstractEXIBodyCoder.ElementContext decodeEndElementUndeclaredStructure() throws EXIException, IOException {
        this.getCurrentGrammar().learnEndElement();
        return this.popElement();
    }

    protected final void decodeAttributeXsiNilStructure() throws EXIException, IOException {
        boolean xsiNil;
        this.attributeQNameContext = this.decoderContext.getXsiNilContext();
        this.handleAttributePrefix(this.attributeQNameContext);
        this.attributeValue = this.preserveLexicalValues ? this.typeDecoder.readValue(this.booleanDatatype, this.decoderContext, this.decoderContext.getXsiNilContext(), this.channel) : this.booleanDatatype.readValue(this.decoderContext, null, this.channel);
        if (this.attributeValue instanceof BooleanValue) {
            BooleanValue bv = (BooleanValue)this.attributeValue;
            xsiNil = bv.toBoolean();
        } else {
            this.booleanDatatype.isValid(this.attributeValue);
            xsiNil = this.booleanDatatype.getBoolean();
        }
        Grammar currentGrammar = this.getCurrentGrammar();
        if (xsiNil && currentGrammar.isSchemaInformed()) {
            this.updateCurrentRule(((SchemaInformedFirstStartTagGrammar)currentGrammar).getTypeEmpty());
        }
    }

    protected final void decodeAttributeXsiTypeStructure() throws EXIException, IOException {
        this.attributeQNameContext = this.decoderContext.getXsiTypeContext();
        this.handleAttributePrefix(this.attributeQNameContext);
        QNameContext qncType = null;
        if (this.preserveLexicalValues) {
            this.attributeValue = this.typeDecoder.readValue(BuiltIn.DEFAULT_DATATYPE, this.decoderContext, this.decoderContext.getXsiTypeContext(), this.channel);
            String sType = this.attributeValue.toString();
            String qncTypePrefix = QNameUtilities.getPrefixPart(sType);
            String qnameURI = this.getURI(qncTypePrefix);
            EvolvingUriContext uc = this.decoderContext.getUriContext(qnameURI);
            if (uc != null) {
                String qnameLocalName = QNameUtilities.getLocalPart(sType);
                qncType = uc.getQNameContext(qnameLocalName);
            }
        } else {
            String qncTypePrefix;
            qncType = this.decoderContext.decodeQName(this.channel);
            if (this.preservePrefix) {
                qncTypePrefix = this.decoderContext.decodeQNamePrefix(this.decoderContext.getUriContext(qncType.getNamespaceUriID()), this.channel);
            } else {
                this.checkDefaultPrefixNamespaceDeclaration(qncType);
                qncTypePrefix = qncType.getDefaultPrefix();
            }
            this.attributeValue = new QNameValue(qncType.getNamespaceUri(), qncType.getLocalName(), qncTypePrefix);
        }
        if (qncType != null && qncType.getTypeGrammar() != null) {
            this.updateCurrentRule(qncType.getTypeGrammar());
        }
    }

    protected final void handleElementPrefix(QNameContext qnc) throws IOException {
        String pfx;
        if (this.preservePrefix) {
            pfx = this.decoderContext.decodeQNamePrefix(this.decoderContext.getUriContext(qnc.getNamespaceUriID()), this.channel);
        } else {
            this.checkDefaultPrefixNamespaceDeclaration(qnc);
            pfx = qnc.getDefaultPrefix();
        }
        this.getElementContext().setPrefix(pfx);
    }

    protected final void handleAttributePrefix(QNameContext qnc) throws IOException {
        if (this.preservePrefix) {
            this.attributePrefix = this.decoderContext.decodeQNamePrefix(this.decoderContext.getUriContext(qnc.getNamespaceUriID()), this.channel);
        } else {
            this.checkDefaultPrefixNamespaceDeclaration(qnc);
            this.attributePrefix = qnc.getDefaultPrefix();
        }
    }

    private final String getPrefix(String uri) {
        int i = 1;
        while (i <= this.elementContextStackIndex) {
            AbstractEXIBodyCoder.ElementContext ec = this.elementContextStack[i];
            if (ec.nsDeclarations != null) {
                for (NamespaceDeclaration ns : ec.nsDeclarations) {
                    if (!ns.namespaceURI.equals(uri)) continue;
                    return ns.prefix;
                }
            }
            ++i;
        }
        return null;
    }

    protected final void checkDefaultPrefixNamespaceDeclaration(QNameContext qnc) {
        assert (!this.preservePrefix);
        if (qnc.getNamespaceUriID() >= this.numberOfUriContexts) {
            String uri = qnc.getNamespaceUri();
            String pfx = this.getPrefix(uri);
            if (pfx == null) {
                pfx = qnc.getDefaultPrefix();
                this.declarePrefix(pfx, uri);
            }
            assert (qnc.getDefaultPrefix().equals(pfx));
        }
    }

    protected final Datatype decodeAttributeStructure() throws EXIException, IOException {
        Attribute at = (Attribute)this.nextEvent;
        this.attributeQNameContext = at.getQNameContext();
        this.handleAttributePrefix(this.attributeQNameContext);
        this.updateCurrentRule(this.nextGrammar);
        return at.getDatatype();
    }

    protected final void decodeAttributeNSStructure() throws EXIException, IOException {
        AttributeNS atNS = (AttributeNS)this.nextEvent;
        EvolvingUriContext uc = this.decoderContext.getUriContext(atNS.getNamespaceUriID());
        this.attributeQNameContext = this.decoderContext.decodeLocalName(uc, this.channel);
        this.handleAttributePrefix(this.attributeQNameContext);
        this.updateCurrentRule(this.nextGrammar);
    }

    protected final void decodeAttributeAnyInvalidValueStructure() throws EXIException, IOException {
        this.decodeAttributeGenericStructureOnly();
    }

    protected final void decodeAttributeGenericStructure() throws EXIException, IOException {
        this.decodeAttributeGenericStructureOnly();
        this.updateCurrentRule(this.nextGrammar);
    }

    protected final void decodeAttributeGenericUndeclaredStructure() throws EXIException, IOException {
        this.decodeAttributeGenericStructureOnly();
        this.getCurrentGrammar().learnAttribute(new Attribute(this.attributeQNameContext));
    }

    private final void decodeAttributeGenericStructureOnly() throws EXIException, IOException {
        this.attributeQNameContext = this.decoderContext.decodeQName(this.channel);
        this.handleAttributePrefix(this.attributeQNameContext);
    }

    protected final Datatype decodeCharactersStructure() throws EXIException {
        assert (this.nextEventType == EventType.CHARACTERS);
        this.updateCurrentRule(this.nextGrammar);
        return ((Characters)this.nextEvent).getDatatype();
    }

    protected final void decodeCharactersGenericStructure() throws EXIException {
        assert (this.nextEventType == EventType.CHARACTERS_GENERIC);
        this.updateCurrentRule(this.nextGrammar);
    }

    protected final void decodeCharactersGenericUndeclaredStructure() throws EXIException {
        assert (this.nextEventType == EventType.CHARACTERS_GENERIC_UNDECLARED);
        Grammar currentGrammar = this.getCurrentGrammar();
        currentGrammar.learnCharacters();
        this.updateCurrentRule(currentGrammar.getElementContentGrammar());
    }

    protected final NamespaceDeclaration decodeNamespaceDeclarationStructure() throws EXIException, IOException {
        EvolvingUriContext euc = this.decoderContext.decodeUri(this.channel);
        String nsPrefix = this.decoderContext.decodeNamespacePrefix(euc, this.channel);
        boolean local_element_ns = this.channel.decodeBoolean();
        if (local_element_ns) {
            this.getElementContext().setPrefix(nsPrefix);
        }
        NamespaceDeclaration nsDecl = new NamespaceDeclaration(euc.getNamespaceUri(), nsPrefix);
        this.declarePrefix(nsDecl);
        return nsDecl;
    }

    protected final char[] decodeEntityReferenceStructure() throws EXIException, IOException {
        char[] er = this.channel.decodeString();
        this.updateCurrentRule(this.getCurrentGrammar().getElementContentGrammar());
        return er;
    }

    protected final char[] decodeCommentStructure() throws EXIException, IOException {
        char[] comment = this.channel.decodeString();
        this.updateCurrentRule(this.getCurrentGrammar().getElementContentGrammar());
        return comment;
    }

    protected final ProcessingInstruction decodeProcessingInstructionStructure() throws EXIException, IOException {
        String piTarget = new String(this.channel.decodeString());
        String piData = new String(this.channel.decodeString());
        this.updateCurrentRule(this.getCurrentGrammar().getElementContentGrammar());
        return new ProcessingInstruction(piTarget, piData);
    }

    protected final DocType decodeDocTypeStructure() throws EXIException, IOException {
        char[] name = this.channel.decodeString();
        char[] publicID = this.channel.decodeString();
        char[] systemID = this.channel.decodeString();
        char[] text = this.channel.decodeString();
        return new DocType(name, publicID, systemID, text);
    }

    public void decodeStartSelfContainedFragment() throws EXIException, IOException {
        throw new RuntimeException("[EXI] SelfContained");
    }
}

