/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region.utils;

import de.fraunhofer.sit.c2x.pki.ca.validator.region.UTMCoordinate;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.WGSCoordinate;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class WgsToUtmConverter implements Converter<WGSCoordinate, UTMCoordinate> {

	/** WGS-84 Durchmesser am quator */
	public final static double EquatorialRadius = 6378137;
	/** TODO: insert field comment */
	public final static double eccentricitySquared = 0.00669438;

	/** Rechenkonstante */
	private final static double deg2rad = Math.PI / 180;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.preserve.pki.ca.utils.Converter#convert(java.lang.Object)
	 */
	@Override
	public UTMCoordinate convert(WGSCoordinate object) {

		double longitude = object.getLongitude();
		double latitude = object.getLatitude();

		double a = EquatorialRadius;
		double eccSquared = eccentricitySquared;
		double k0 = UTMCoordinate.factor;

		// Make sure the longitude is between -180.00 .. 179.9
		longitude += 180;
		longitude %= 360;
		if (longitude < 0)
			longitude += 360;
		longitude -= 180;

		double latRad = latitude * deg2rad;
		double longRad = longitude * deg2rad;

		/* compute the UTM Zone from longitude and latitude */
		String UTMZone = UTMCoordinate.calcUTMZone(longitude, latitude);
		// String UTMZone = UTMCoordinate.DefaultUTMZone; // simplification for
		// simTD
		int zoneNumber = Integer.valueOf(UTMZone.substring(0, 2));
		// int zoneNumber = 32; // simplification for simTD

		double longOrigin = (zoneNumber - 1) * 6 - 180 + 3; // +3 puts origin in
		// middle of zone
//		double longOrigin = 9; // simplification for simTD
		double longOriginRad = longOrigin * deg2rad;

		// double eccPrimeSquared = (eccSquared)/(1-eccSquared);
		double eccPrimeSquared = 0.006739496752268451; // simplification for
														// simTD

		double N = a / Math.sqrt(1 - eccSquared * Math.sin(latRad) * Math.sin(latRad));
		double T = Math.tan(latRad) * Math.tan(latRad);
		double C = eccPrimeSquared * Math.cos(latRad) * Math.cos(latRad);
		double A = Math.cos(latRad) * (longRad - longOriginRad);

		double M = a
				* ((1 - eccSquared / 4 - 3 * eccSquared * eccSquared / 64 - 5 * eccSquared * eccSquared
						* eccSquared / 256)
						* latRad
						- (3 * eccSquared / 8 + 3 * eccSquared * eccSquared / 32 + 45 * eccSquared
								* eccSquared * eccSquared / 1024)
						* Math.sin(2 * latRad)
						+ (15 * eccSquared * eccSquared / 256 + 45 * eccSquared * eccSquared * eccSquared
								/ 1024) * Math.sin(4 * latRad) - (35 * eccSquared * eccSquared * eccSquared / 3072)
						* Math.sin(6 * latRad));

		double UTMEasting = (double) (k0
				* N
				* (A + (1 - T + C) * A * A * A / 6 + (5 - 18 * T + T * T + 72 * C - 58 * eccPrimeSquared) * A
						* A * A * A * A / 120) + 500000.0);
		double UTMNorthing = (double) (k0 * (M + N
				* Math.tan(latRad)
				* (A * A / 2 + (5 - T + 9 * C + 4 * C * C) * A * A * A * A / 24 + (61 - 58 * T + T * T + 600
						* C - 330 * eccPrimeSquared)
						* A * A * A * A * A * A / 720)));
		if (latitude < 0)
			UTMNorthing += 10000000.0; // 10000000 meter offset for southern
										// hemisphere

		return new UTMCoordinate(Math.round(UTMEasting), Math.round(UTMNorthing), UTMZone);
	}

}
