package de.fraunhofer.sit.c2x.pki.ca.provider.interfaces;

import de.fraunhofer.sit.c2x.pki.ca.core.interfaces.Service;
import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.Authenticator;

/**
 * @author Norbert Bissmeyer (norbert.bissmeyer@sit.fraunhofer.de)
 */
public interface AuthenticatorProvider extends Service {

	public boolean save(Authenticator authenticator) throws ProviderException ;
	
	public Authenticator get(String emailAddress) throws ProviderException ;
	
	public Authenticator[] getAll(int offset, int limit) throws ProviderException ;

	int removeAuthenticator(String email) throws ProviderException;

	Authenticator[] getRegisteredByUser(String httpUser) throws ProviderException;
}
