package de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.Servlet;

/**
 * Delivers files for http web server
 * 
 * @author Norbert Bissmeyer (norbert.bissmeyer@sit.fraunhofer.de)
 * 
 */
public class ContentProvider extends HttpServlet implements Servlet {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	public static final String URL = "/webpage/*";
	private static Map<String, String> contentTypes;

	static {
		contentTypes = new HashMap<String, String>();
		contentTypes.put("html", "text/html");
		contentTypes.put("css", "text/css");
		contentTypes.put("js", "text/javascript");
		contentTypes.put("png", "image/png");
		contentTypes.put("gif", "image/gif");
		contentTypes.put("jpg", "image/jpeg");
	}

	public ContentProvider() {
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
		OutputStream body = response.getOutputStream();
		String path = request.getPathInfo();

		byte[] buffer = new byte[8192];
		int read;
		String resource;
		/* Get resource path. */
		resource = "/webpage" + path;

		/* Get Content-Type. */
		String extension = resource.substring(resource.lastIndexOf('.') + 1);
		String contentType = contentTypes.get(extension);

		/* Get resource as stream. */
		InputStream stream = ContentProvider.class.getResourceAsStream(resource);
		/* Check if resource was found. */
		if (stream != null) {
			/* Set headers. */
			response.setHeader("Content-Type", contentType);
			response.setHeader("Cache-Control", "max-age=604800");
			response.setCharacterEncoding("UTF-8");

			/* Send response header with Content-Length. */
			response.setStatus(200);
			response.setContentLength(stream.available());

			/* Write response to output stream. */
			while ((read = stream.read(buffer)) != -1) {
				body.write(buffer, 0, read);
			}
		} else {
			byte[] bytes = "404 Not Found".getBytes();

			/* Send response header with Content-Length. */
			response.setStatus(404);
			response.setContentLength(bytes.length);

			body.write(bytes);
		}

		/* Close. */
		body.close();
	}

	@Override
	public String getUrl() {
		return URL;
	}

	@Override
	public String getTitle() {
		return "";
	}

	@Override
	public boolean isProtected() {
		return false;
	}

	@Override
	public String[] getAllowedRoles() {
		return new String[] {};
	}
	
	@Override
	public Category getCategory() {
		return Category.NONE;
	}
}
