#pragma once

#include "codec.hh"
#include "params.hh"

class Base_Type;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;

namespace LibItsHttp__TypesAndValues {
  class HttpMessage;
  class Request;
  class Response;
  class HeaderLines;
  class HeaderLine;
}

class http_codec: public codec <
LibItsHttp__TypesAndValues::HttpMessage,
LibItsHttp__TypesAndValues::HttpMessage>
{
public:
  explicit http_codec() : codec<LibItsHttp__TypesAndValues::HttpMessage, LibItsHttp__TypesAndValues::HttpMessage>() { };
  virtual ~http_codec() { };

  virtual int encode (const LibItsHttp__TypesAndValues::HttpMessage&, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, LibItsHttp__TypesAndValues::HttpMessage&, params* params = NULL);

private:
  int encode_request (const LibItsHttp__TypesAndValues::Request& p_request, TTCN_Buffer& p_encoding_buffer);
//  int encode_response (const LibItsHttp__TypesAndValues::Request&, TTCN_Buffer& p_encoding_buffer);

  int decode_headers(TTCN_Buffer& decoding_buffer, LibItsHttp__TypesAndValues::HeaderLines& headers);
  int decode_header(CHARSTRING& header_line, LibItsHttp__TypesAndValues::HeaderLine& header);
  int decode_body(TTCN_Buffer& decoding_buffer, CHARSTRING& body);
  int get_line(TTCN_Buffer& buffer, CHARSTRING& to, const bool concatenate_header_lines = false);

}; // End of class http_codec
