package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.NoSuchElementException;

import org.apache.commons.codec.binary.Hex;

import de.fraunhofer.sit.c2x.pki.ca.core.exceptions.HandlerException;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.EtsiPerrmissionUtils;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class SubjectAssurance extends WaveElement {

	@Internal(order = 0)
	private Opaque subjectAssurance = new Opaque(new byte[] { 0 }, 1, true);

	public SubjectAssurance() {
	}

	public SubjectAssurance(byte[] subjectAssurance) {
		this.subjectAssurance = new Opaque(subjectAssurance, 1, true);
	}

	public SubjectAssurance(DataInputStream in) throws IOException {

		this.subjectAssurance = new Opaque(in, 1, true);

	}

	public Opaque getSubjectAssurance() {
		return subjectAssurance;
	}

	public void setSubjectAssurance(Opaque subjectAssurance) {
		this.subjectAssurance = subjectAssurance;
	}

	public String toHex() {
		if (subjectAssurance != null && subjectAssurance.get() != null)
			return Hex.encodeHexString(subjectAssurance.get());
		else
			throw new NoSuchElementException("Subject assurance level not available");
	}
	
	public int toInt() throws HandlerException {
		if (subjectAssurance != null && subjectAssurance.get() != null)
			return EtsiPerrmissionUtils.subjectAssuranceByteToInt(subjectAssurance.get());
		else
			throw new NoSuchElementException("Subject assurance level not available");
	}

	@Override
	public String toString() {
		return "SubjectAssurance [subjectAssurance=" + Hex.encodeHexString(subjectAssurance.get()) + "]";
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {

		int written = 0;
		if (subjectAssurance == null)
			throw new IllegalArgumentException();
		written += subjectAssurance.writeData(out);
		return written;
	}

}
