/*
 * ----------------------------------------------------------------------------
 *  (C) Copyright Testing Technologies, 2001-2015.  All Rights Reserved.
 *
 *  All copies of this program, whether in whole or in part, and whether
 *  modified or not, must display this and all other embedded copyright
 *  and ownership notices in full.
 *
 *  See the file COPYRIGHT for details of redistribution and use.
 *
 *  You should have received a copy of the COPYRIGHT file along with
 *  this file; if not, write to the Testing Technologies,
 *  Michaelkirchstr. 17/18, 10179 Berlin, Germany.
 *
 *  TESTING TECHNOLOGIES DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *  SOFTWARE. IN NO EVENT SHALL TESTING TECHNOLOGIES BE LIABLE FOR ANY
 *  SPECIAL, DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 *  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 *  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 *  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 *  THIS SOFTWARE.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 *  EITHER EXPRESSED OR IMPLIED, INCLUDING ANY KIND OF IMPLIED OR
 *  EXPRESSED WARRANTY OF NON-INFRINGEMENT OR THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * ----------------------------------------------------------------------------- */
/**
 *  GNSS support interface to be implemented by TE providers.
 */
package org.etsi.adapter;

import java.math.BigInteger;

import org.etsi.its.adapter.ports.AdapterPort;
import org.etsi.ttcn.tri.TriStatus;

/**
 *  Test Execution Required interface to be implemented by TE providers.
 */
public interface IGnssSupport {

  /**
   * Initialize the GNSS support.
   * @return TRI_OK in case of success, false otherwise
   */
  public TriStatus init();
  
  /**
   * Loads a scenario
   * @param id of predefined scenario
   * @return TRUE on success, FALSE otherwise
   */
  public boolean loadScenario(int p_id);
  
  /**
   * Starts a loaded scenario
   * @return TRUE on success, FALSE otherwise
   */
  public boolean startScenario();
  
  /**
   * Stops a started scenario
   * @return TRUE on success, FALSE otherwise
   */
  public boolean stopScenario();
  
  /**
   * Signals when the requested distance was covered
   * @param distance The requested distance in m.
   * @return TRUE on success, FALSE otherwise
   */
  public boolean awaitDistanceToCover(AdapterPort notifier, double distance);
  
  /**
   * Changes dynamically the speed in the running scenario
   * @param The new speed value.
   * @return TRUE on success, FALSE otherwise
   */
  public boolean changeSpeed(double speed);
  
  /**
   * Changes dynamically the heading in the running scenario
   * @param heading The new heading value.
   * @return TRUE on success, FALSE otherwise
   */
  public boolean changeHeading(double heading);
  
  /**
   * Gets the current GPS time
   * @return the time
   */
  public BigInteger getGpsTime();
  
  /**
   * Signals when the requested time in the running scenario is reached
   * @param time The requested time in msec.
   * @return TRUE on success, FALSE otherwise
   */
  public boolean awaitTimeInRunningScenario(AdapterPort notifier, int time);
  
  /**
   * Dispose object
   */
  public void dispose();
  
}
