#include <string>
//#include <typeinfo>

#include "UpperTesterSremSsemCodec.hh"
#include "loggers.hh"

#include "UpperTesterTypes.hh"

#include "SremCodec.hh"
#include "SsemCodec.hh"

template <typename T_type> class OPTIONAL;
class TTCN_EncDec;

int UpperTesterSremSsemCodec::encode (const Record_Type& msg, OCTETSTRING& data)
{
  loggers::get_instance().log_msg(">>> UpperTesterSremSsemCodec::encode: ", (const Record_Type&)msg);
  
  TTCN_EncDec::clear_error();
  TTCN_Buffer encoding_buffer;
  if (std::string(msg.get_descriptor()->name).compare("@LibItsSremSsem_TypesAndValues.UtSremSsemInitialize") == 0) {
    encoding_buffer.put_c(static_cast<const unsigned char>(UpperTesterSremSsemCodec::c_utSremSsemInitialize));
  } else if (std::string(msg.get_descriptor()->name).compare("@LibItsSremSsem_TypesAndValues.UtSremSsemTrigger") == 0) {
    encoding_buffer.put_c(static_cast<const unsigned char>(UpperTesterSremSsemCodec::c_utSremSsemTrigger));
  } else { // Error
    data = OCTETSTRING();
    loggers::get_instance().log("<<< UpperTesterSremSsemCodec::encode: Return -1");
    return -1;
  }
  encode_(msg, *msg.get_descriptor(), encoding_buffer);
  data = OCTETSTRING(encoding_buffer.get_len(), encoding_buffer.get_data());
  loggers::get_instance().log_msg("<<< UpperTesterSremSsemCodec::encode: data=", data);
  return 0;
}

int UpperTesterSremSsemCodec::encode_ (const Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& encoding_buffer)
{
  loggers::get_instance().log(">>> UpperTesterSremSsemCodec::encode_: processing %s/%s/%p", type.get_descriptor()->name, field_descriptor.name, dynamic_cast<const Record_Type*>(&type));
  loggers::get_instance().log_msg(">>> UpperTesterSremSsemCodec::encode_: ", type);
  
  if (dynamic_cast<const Record_Type*>(&type) != NULL) {
    const Record_Type& r = (const Record_Type &)type;
    loggers::get_instance().log("UpperTesterSremSsemCodec::encode_: processing Record_Type %s", r.get_descriptor()->name);
    for(int i = 0; i < r.get_count(); i++) {
      loggers::get_instance().log("UpperTesterSremSsemCodec::encode_: processing %s/%s/%s - %d (1 ==> use dynamic_cast<const OPTIONAL<...>) - %d", r.fld_name(i), r.fld_descr(i)->name, r.get_at(i)->get_descriptor()->name, r.get_at(i)->is_optional(), r.get_at(i)->is_present());
      if (r.get_at(i)->is_present()) {
        if (encode_(*r.get_at(i), *r.fld_descr(i), encoding_buffer) == -1) {
          loggers::get_instance().warning("UpperTesterSremSsemCodec::encode_: -1 result code returned");
          return -1;
        }
      } else if (std::string(r.fld_name(i)).compare("alacarte") == 0) {
        // Add empty field length
        loggers::get_instance().log("UpperTesterSremSsemCodec::encode_: alacarte is missing, add 0x00");
        encoding_buffer.put_c(0x00);
      }
    } // End of 'for' statement
  } else {
    std::string s(field_descriptor.name);
    loggers::get_instance().log("UpperTesterSremSsemCodec::encode_: field to process %s", s.c_str());
      loggers::get_instance().log("UpperTesterSremSsemCodec::encode_ (else): processing type %s/%s", type.get_descriptor()->name, field_descriptor.name);
      type.encode(field_descriptor, encoding_buffer, TTCN_EncDec::CT_RAW);

  }
  
  loggers::get_instance().log_to_hexa("<<<UpperTesterSremSsemCodec::encode_: encoding_buffer=", encoding_buffer);
  return 0;
}

int UpperTesterSremSsemCodec::decode (const OCTETSTRING& data, Record_Type& msg, Params* params)
{
  TTCN_EncDec::clear_error();
  TTCN_Buffer decoding_buffer(data);
  _params = params;
  
  loggers::get_instance().log_to_hexa(">>> UpperTesterSremSsemCodec::decode: decoding_buffer=", decoding_buffer);
  //decode_(msg, *msg.get_descriptor(), decoding_buffer);
  
  loggers::get_instance().log_msg("<<< UpperTesterSremSsemCodec::decode: ", (const Record_Type&)msg);
  return 0;
}

std::unique_ptr<Base_Type> UpperTesterSremSsemCodec::decode (const OCTETSTRING& data, Params* params) {

  std::unique_ptr<Base_Type> result;
  
  const unsigned char* ptr = static_cast<const unsigned char*>(data);
  if ((*ptr != UpperTesterSremSsemCodec::c_utSremEventInd) && (*ptr != UpperTesterSremSsemCodec::c_utSsemEventInd)) {
    LibItsSremSsem__TypesAndValues::UtSremResults res;
    decode(data, res, params);
    result.reset((Base_Type *)res.clone());
  } else if (*ptr == UpperTesterSremSsemCodec::c_utSremEventInd) {
    LibItsSremSsem__TypesAndValues::UtSremEventInd res;
    decode(data, res, params);
    result.reset((Base_Type *)res.clone());
  } else {
    LibItsSremSsem__TypesAndValues::UtSsemEventInd ind;
    decode(data, ind, params);
    result.reset((Base_Type *)ind.clone());
  }

  return result;
}

int UpperTesterSremSsemCodec::decode (const OCTETSTRING& data, LibItsSremSsem__TypesAndValues::UtSremResults& msg, Params* params)
{
  loggers::get_instance().log_to_hexa(">>> UpperTesterSremSsemCodec::decode: decoding_buffer=", data);

  
  loggers::get_instance().log_msg("<<< UpperTesterSremSsemCodec::decode", msg);
  return 0;
}

int UpperTesterSremSsemCodec::decode (const OCTETSTRING& data, LibItsSremSsem__TypesAndValues::UtSremEventInd& msg, Params* params)
{
  loggers::get_instance().log_to_hexa(">>> UpperTesterSremSsemCodec::decode: decoding_buffer=", data);

  
  loggers::get_instance().log_msg("<<< UpperTesterSremSsemCodec::decode", msg);
  return 0;
}

int UpperTesterSremSsemCodec::decode (const OCTETSTRING& data, LibItsSremSsem__TypesAndValues::UtSsemEventInd& msg, Params* params)
{
  loggers::get_instance().log_to_hexa(">>> UpperTesterSremSsemCodec::decode: decoding_buffer=", data);

  
  loggers::get_instance().log_msg("<<< UpperTesterSremSsemCodec::decode", msg);
  return 0;
}
