#include "UpperTesterIvimFactory.hh"

#include "UpperTesterTypes.hh"

#include "loggers.hh"

UpperTesterIvimLayer::UpperTesterIvimLayer(const std::string & p_type, const std::string & param) : t_layer<LibItsIvim__TestSystem::UpperTesterPort>(p_type), _params(), _codec() {
  loggers::get_instance().log(">>> UpperTesterIvimLayer::UpperTesterIvimLayer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  Params::convert(_params, param);
}

void UpperTesterIvimLayer::sendMsg(const LibItsIvim__TypesAndValues::UtIvimInitialize& send_par, Params& params){
  loggers::get_instance().log_msg(">>> UpperTesterIvimLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  send_data(data, params);
}

void UpperTesterIvimLayer::sendMsg(const LibItsIvim__TypesAndValues::UtIvimTrigger& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterIvimLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  send_data(data, params);
}

void UpperTesterIvimLayer::sendMsg(const LibItsIvim__TypesAndValues::UtIvimUpdate& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterIvimLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode(send_par, data);
  // Update parameters
  send_data(data, params);
}

void UpperTesterIvimLayer::sendMsg(const LibItsIvim__TypesAndValues::UtIvimTermination& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterIvimLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode(send_par, data);
  // Update parameters
  send_data(data, params);
}

void UpperTesterIvimLayer::send_data(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log_msg(">>> UpperTesterIvimLayer::send_data: ", data);
  //params.log();
  send_to_all_layers(data, params);
}

void UpperTesterIvimLayer::receive_data(OCTETSTRING& data, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterIvimLayer::receive_data: ", data);
 
  std::unique_ptr<Base_Type> r = _codec.decode(data);
  if (r.get() != nullptr) {
    // Pass it to the ports if amy
    to_all_upper_ports(*r, params);
  }
}

UpperTesterIvimFactory UpperTesterIvimFactory::_f;
