#include "UpperTesterGnFactory.hh"

#include "UpperTesterTypes.hh"

#include "loggers.hh"

UpperTesterGnLayer::UpperTesterGnLayer(const std::string & p_type, const std::string & param) : t_layer<LibItsGeoNetworking__TestSystem::UpperTesterPort>(p_type), _params(), _codec() {
  loggers::get_instance().log(">>> UpperTesterGnLayer::UpperTesterGnLayer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  Params::convert(_params, param);
  Params::const_iterator it = _params.find(Params::loopback);
  if (it == _params.cend()) {
    _params.insert(std::pair<std::string, std::string>(Params::loopback, "0"));
  }
}

void UpperTesterGnLayer::sendMsg(const LibItsGeoNetworking__TypesAndValues::UtGnInitialize& send_par, Params& params){
  loggers::get_instance().log_msg(">>> UpperTesterGnLayer::sendMsg", send_par);

  if (_params[Params::loopback].compare("1") == 0) {
    LibItsGeoNetworking__TypesAndValues::UtGnResults ut_gn_results;
    ut_gn_results.utGnInitializeResult() = BOOLEAN(true);
    to_all_upper_ports(ut_gn_results, params);
  } else {
    // Encode UpperTester PDU
    OCTETSTRING data;
    _codec.encode(static_cast<const Record_Type&>(send_par), data);
    // Update parameters
    Params par(params); // FIXME Review all const Param& in method declarations
    send_data(data, params);
  }
}

void UpperTesterGnLayer::sendMsg(const LibItsGeoNetworking__TypesAndValues::UtGnChangePosition& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterGnLayer::sendMsg", send_par);

  if (_params[Params::loopback].compare("1") == 0) {
    LibItsGeoNetworking__TypesAndValues::UtGnResults ut_gn_results;
    ut_gn_results.utGnChangePositionResult() = BOOLEAN(true);
    to_all_upper_ports(ut_gn_results, params);
  } else {
    // Encode UpperTester PDU
    OCTETSTRING data;
    _codec.encode(static_cast<const Record_Type&>(send_par), data);
    // Update parameters
    Params par(params); // FIXME Review all const Param& in method declarations
    send_data(data, params);
  }
}

void UpperTesterGnLayer::sendMsg(const LibItsGeoNetworking__TypesAndValues::UtGnTrigger& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterGnLayer::sendMsg", send_par);

  if (_params[Params::loopback].compare("1") == 0) {
    LibItsGeoNetworking__TypesAndValues::UtGnResults ut_gn_results;
    ut_gn_results.utGnTriggerResult() = BOOLEAN(true);
    to_all_upper_ports(ut_gn_results, params);
  } else {
    // Encode UpperTester PDU
    OCTETSTRING data;
    _codec.encode((const Record_Type&)send_par, data);
    // Update parameters
    Params par(params); // FIXME Review all const Param& in method declarations
    send_data(data, params);
  }
}

void UpperTesterGnLayer::sendMsg(const LibItsGeoNetworking__TypesAndValues::UtAutoInteropTrigger& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterGnLayer::sendMsg", send_par);

  if (_params[Params::loopback].compare("1") == 0) {
    LibItsGeoNetworking__TypesAndValues::UtGnResults ut_gn_results;
    ut_gn_results.utGnTriggerResult() = BOOLEAN(true);
    to_all_upper_ports(ut_gn_results, params);
  } else {
    // Encode UpperTester PDU
    OCTETSTRING data;
    _codec.encode((const Record_Type&)send_par, data);
    // Update parameters
    Params par(params); // FIXME Review all const Param& in method declarations
    send_data(data, params);
  }
}

void UpperTesterGnLayer::send_data(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log_msg(">>> UpperTesterGnLayer::send_data: ", data);
  //params.log();
  send_to_all_layers(data, params);
}

void UpperTesterGnLayer::receive_data(OCTETSTRING& data, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterGnLayer::receive_data: ", data);
  std::unique_ptr<Base_Type> r = _codec.decode(data);
  if (r.get() != nullptr) {
    // Pass it to the ports if amy
    to_all_upper_ports(*r, params);
  }
}

UpperTesterGnFactory UpperTesterGnFactory::_f;
