#ifndef UpperTesterDenm_LAYER_H
#define UpperTesterDenm_LAYER_H

#include <memory>

#include "t_layer.hh"
#include "UpperTesterDenmCodec.hh"

namespace LibItsDenm__TestSystem {
  class UpperTesterPort;
}

namespace LibItsDenm__TypesAndValues {
  class UtDenmInitialize;
  class UtDenmChangePosition;
  class UtDenmChangePseudonym;
  class UtDenmTrigger;
  class UtDenmUpdate;
  class UtDenmTermination;
}

class UpperTesterDenmLayer : public t_layer<LibItsDenm__TestSystem::UpperTesterPort> {
  Params _params;
  UpperTesterDenmCodec _codec;
  
public:
  UpperTesterDenmLayer() : t_layer<LibItsDenm__TestSystem::UpperTesterPort>(), _params(), _codec() {};
  UpperTesterDenmLayer(const std::string & p_type, const std::string & param);
  virtual ~UpperTesterDenmLayer() {};

  void sendMsg(const LibItsDenm__TypesAndValues::UtDenmInitialize& send_par, Params& params);
  void sendMsg(const LibItsDenm__TypesAndValues::UtDenmChangePosition& send_par, Params& params);
  void sendMsg(const LibItsDenm__TypesAndValues::UtDenmChangePseudonym& send_par, Params& params);
  void sendMsg(const LibItsDenm__TypesAndValues::UtDenmTrigger& send_par, Params& params);
  void sendMsg(const LibItsDenm__TypesAndValues::UtDenmUpdate& send_par, Params& params);
  void sendMsg(const LibItsDenm__TypesAndValues::UtDenmTermination& send_par, Params& params);
  
  virtual void send_data(OCTETSTRING& data, Params& params);
  virtual void receive_data(OCTETSTRING& data, Params& info);
};

#endif
