/*!
 * \file      raw_socket_layer.hh
 * \brief     Header file for ITS UDP/IP protocol layer factory.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include <sys/types.h>
#include <sys/socket.h>
#if !defined(LINUX)
#include <netdb.h>
#else // LINUX
#include <netinet/ether.h> // Used for raw sockets
#include <net/ethernet.h> // Used for raw sockets
#include <linux/if_packet.h> // Used for raw sockets
#endif // LINUX
#include <netinet/in.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <net/if.h> // Used for raw sockets

#include "t_layer.hh"
#include "Params.hh"

class OCTETSTRING; //! Forward declaration of TITAN class
class PORT; //! Forward declaration of TITAN class

/*!
 * \class tcp_layer
 * \brief  This class provides description of ITS raw socket port protocol layer
 */
class raw_socket_layer : public layer, public PORT {
  Params _params;                      //! Layer parameters
  int _socket;                         //! Socket identifier
  std::string _time_key;               //! \todo
  struct ifreq _if_interface;          //! NIC interface description
  struct ifreq _if_mac_addr;           //! NIC interface description
  std::vector<unsigned char> _mac_src; //! MAC address
  std::vector<unsigned char> _mac_bc;  //! MAC broadcast address
  std::vector<unsigned char> _eth_type; //! Ethernet type

public: //! \publicsection
  /*!
   * \brief Specialised constructor
   *        Create a new instance of the raw_socket_layer class
   * \param[in] p_type \todo
   * \param[in] p_param \todo
   */

  raw_socket_layer(const std::string& p_type, const std::string& param);
  /*!
   * \brief Default destructor
   * \remark If \see _reconnect_on_send is set to false, the disconnection is done by the destructor
   */
  virtual ~raw_socket_layer();

  /*!
   * \virtual
   * \fn void send_data(OCTETSTRING& data, Params& params);
   * \brief Send bytes formated data to the lower layers
   * \param[in] p_data The data to be sent
   * \param[in] p_params Some parameters to overwrite default value of the lower layers parameters
   * \virtual
   */
  virtual void send_data(OCTETSTRING& data, Params& params);
  /*!
   * \virtual
   * \fn void receive_data(OCTETSTRING& data, Params& params);
   * \brief Receive bytes formated data from the lower layers
   * \param[in] p_data The bytes formated data received
   * \param[in] p_params Some lower layers parameters values when data was received
   */
  virtual void receive_data(OCTETSTRING& data, Params& info);
  
  void Handle_Fd_Event_Readable(int fd);
}; // End of class raw_socket_layer

