#ifndef SPATEMCODEC_H
#define SPATEMCODEC_H

#include "Codec.hh"
#include "per_code.hh"
#include "Params.hh"

#include "LibItsMapemSpatem_TestSystem.hh"

class SpatemPDUCodec : public per_code <SPATEM__PDU__Descriptions::SPATEM>
{
public:
  explicit SpatemPDUCodec() { };
  virtual int encode (const SPATEM__PDU__Descriptions::SPATEM& spatem, BITSTRING& data);
  virtual int decode (const BITSTRING& data, SPATEM__PDU__Descriptions::SPATEM&);
};

class SpatemCodec : public Codec<SPATEM__PDU__Descriptions::SPATEM, SPATEM__PDU__Descriptions::SPATEM>
{
  SpatemPDUCodec asnCodec;

public:
  explicit SpatemCodec() : Codec<SPATEM__PDU__Descriptions::SPATEM, SPATEM__PDU__Descriptions::SPATEM>(), asnCodec() { };
  virtual ~SpatemCodec() { };

  virtual int encode (const SPATEM__PDU__Descriptions::SPATEM& spatem, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, SPATEM__PDU__Descriptions::SPATEM&, Params* params = NULL);
};

#endif
