#include "LibItsMapemSpatem_TestSystem.hh"
#include "SpatemCodec.hh"
#include "asn1/asn_application.h" // from asn1c
#include "loggers.hh"

int SpatemCodec::encode (const SPATEM__PDU__Descriptions::SPATEM& spatem, OCTETSTRING& data)
{
  loggers::get_instance().log(">>> SpatemCodec::encode");
  
  BITSTRING b;
  int rc = asnCodec.encode(spatem, b);
  if(rc){
    data = bit2oct(b);
    loggers::get_instance().log_msg("SpatemCodec::encode: ", data);
  }
  return rc;
}

int SpatemCodec::decode (const OCTETSTRING& data, SPATEM__PDU__Descriptions::SPATEM& spatem, Params* params)
{
  loggers::get_instance().log_msg(">>> SpatemCodec::decode: ", data);
  
  int rc = asnCodec.decode(oct2bit(data), spatem);
  loggers::get_instance().log("SpatemCodec::decode: ASN.1 codec returned %d", rc);
  if(rc) {
    loggers::get_instance().log_msg("SpatemCodec::decode: ", spatem);
  }
  return rc;
}

extern "C" {
  extern asn_TYPE_descriptor_t asn_DEF_SPATEM;
}

int SpatemPDUCodec::encode (const SPATEM__PDU__Descriptions::SPATEM& p_spatem, BITSTRING& p_data)
{
  return _encode(SPATEM__PDU__Descriptions::SPATEM_descr_, asn_DEF_SPATEM, p_spatem, p_data);
}

int SpatemPDUCodec::decode (const BITSTRING& p_data, SPATEM__PDU__Descriptions::SPATEM& p_spatem)
{
  return _decode(SPATEM__PDU__Descriptions::SPATEM_descr_, asn_DEF_SPATEM, p_data, p_spatem);
}
