#ifndef GNCODEC_H
#define GNCODEC_H

#include "Codec.hh"
#include "Params.hh"

class Base_Type;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;

namespace LibItsGeoNetworking__TypesAndValues {
  class GeoNetworkingPdu;
  class GnNonSecuredPacket;
  class HeaderTST;
  class ExtendedHeader;
  class DecodedPayload;
};

namespace LibItsSecurity__TypesAndValues {
  class SecuredMessage;
};

struct Encoding_Context {
  unsigned char next_header;
  unsigned char header_type;
  unsigned int  length_position;
  unsigned int  length;

  Encoding_Context() { next_header = 0xff; header_type = 0xff; length_position = -1; length = -1; }
};
//typedef struct Encoding_Context Encoding_Context;

struct Decoding_Context {
  unsigned char              next_header;
  unsigned char              header_type;
  unsigned char              header_sub_type;
  unsigned char              traffic_class;
  unsigned int               lifetime;
  unsigned int               length;
  std::string                payload;

  Decoding_Context() : payload() { next_header = 0xff; header_type = 0xff; header_sub_type = 0xff; lifetime = 0; length = -1; }
};
//typedef struct Decoding_Context Decoding_Context;

class GeoNetworkingCodec : public Codec<LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu, LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu> {

  Encoding_Context _ec;
  Decoding_Context _dc;

  int encode_ (const Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& encoding_buffer);
  int encode_extendedHeader(const LibItsGeoNetworking__TypesAndValues::ExtendedHeader& u, TTCN_Buffer& encoding_buffer);

  int decode_ (Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& decoding_buffer);
  int decode_headerTST(LibItsGeoNetworking__TypesAndValues::HeaderTST& u, TTCN_Buffer& decoding_buffer);
  int decode_extendedHeader(LibItsGeoNetworking__TypesAndValues::ExtendedHeader& u, TTCN_Buffer& decodin_buffer);

public:
  explicit GeoNetworkingCodec() : Codec<LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu, LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu>(), _ec(), _dc() { };
  virtual ~GeoNetworkingCodec() { };
  
  virtual int encode (const LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu& msg, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu& msg, Params* params = NULL);
  
  int encode (const LibItsGeoNetworking__TypesAndValues::GnNonSecuredPacket& p_gnNonSecuredPacket, OCTETSTRING& data); // TODO Duplicate code with virtual encode, to be enhanced
};

#endif
