#include <algorithm>
#include <cctype>
#include <arpa/inet.h>

#include "commsignia_layer_factory.hh"

#include "loggers.hh"

#include "converter.hh"

commsignia_layer::commsignia_layer(const std::string & p_type, const std::string & param) : layer(p_type), _params(), _c2p_recv{0}, _802_11p_hdr{0}, _c2p_llc_hdr{0}, _mac_src(), _eth_type() {
  loggers::get_instance().log(">>> commsignia_layer::commsignia_layer: %s, %s", to_string().c_str(), param.c_str());
  
  // Setup parameters
  Params::convert(_params, param);
  Params::const_iterator it = _params.find(Params::mac_src);
  if (it == _params.cend()) {
    _params.insert(std::pair<std::string, std::string>(std::string("mac_src"), "000000000000"));
  }
  _mac_src = converter::get_instance().hexa_to_bytes(_params[Params::mac_src]);
  it = _params.find(Params::mac_bc);
  if (it == _params.cend()) {
    _params.insert(std::pair<std::string, std::string>(std::string("mac_bc"), "FFFFFFFFFFFF"));
  }
  it = _params.find(Params::eth_type);
  if (it == _params.cend()) {
    _params.insert(std::pair<std::string, std::string>(std::string("eth_type"), "8947"));
  }
  _eth_type = converter::get_instance().hexa_to_bytes(_params[Params::eth_type]);
  it = _params.find(Params::interface_id);
  if (it == _params.cend()) {
    _params.insert(std::pair<std::string, std::string>(std::string("interface_id"), "1"));
  }
  //_params.log();
}

void commsignia_layer::send_data(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log_msg(">>> commsignia_layer::send_data: ", data);

}

void commsignia_layer::receive_data(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log_msg(">>> commsignia_layer::receive_data: ", data);
  
  const unsigned char* p = static_cast<const unsigned char *>(data);

  const commsignia_layer::c2p_recv* r = (const commsignia_layer::c2p_recv*)p;
  //loggers::get_instance().log("commsignia_layer::receive_data: version=%02x", r->version);
  //loggers::get_instance().log("commsignia_layer::receive_data: timestamp1=%08x", ntohl(r->timestamp_sec));
  //loggers::get_instance().log("commsignia_layer::receive_data: timestamp2=%08x", ntohl(r->timestamp_msec));
  //loggers::get_instance().log("commsignia_layer::receive_data: timestamp2=%08x", ntohl(r->timestamp_msec));
  //loggers::get_instance().log("commsignia_layer::receive_data: antenna=%02x", r->antenna);
  //loggers::get_instance().log("commsignia_layer::receive_data: rssi_ant2=%02x", r->rssi_ant2);
  //loggers::get_instance().log("commsignia_layer::receive_data: noise_ant1=%02x", r->noise_ant1);
  //loggers::get_instance().log("commsignia_layer::receive_data: noise_ant2=%02x", r->noise_ant2);
  // Filtering on antenna index
  //loggers::get_instance().log("commsignia_layer::receive_data: compare %02x with %02x", r->antenna, static_cast<unsigned char>(std::strtoul(_params[Params::interface_id].c_str(), NULL, 10)));
  if (r->antenna != static_cast<unsigned char>(std::strtoul(_params[Params::interface_id].c_str(), NULL, 10))) {
    // Discard packet
    loggers::get_instance().warning("commsignia_layer::receive_data: Discard packet due to wrong antenna id");
    return;
  } // else, continue

  const commsignia_layer::c2p_802_11p_hdr* h = (const commsignia_layer::c2p_802_11p_hdr*)(p + sizeof(commsignia_layer::c2p_recv));
  //loggers::get_instance().log("commsignia_layer::receive_data: frame_ctrl=%04x", ntohs(h->frame_ctrl));
  OCTETSTRING dst = OCTETSTRING(6, (const unsigned char*)&h->dst_addr);
  loggers::get_instance().log_msg("commsignia_layer::receive_data: dst: ", dst);
  OCTETSTRING src = OCTETSTRING(6, (const unsigned char*)&h->src_addr);
  loggers::get_instance().log_msg("commsignia_layer::receive_data: src: ", src);

  // Filtering on source MAC address of the packet
  if (!std::equal(_mac_src.cbegin(), _mac_src.cend(), static_cast<const unsigned char*>(src))) {
    // Discard packet
    loggers::get_instance().warning("commsignia_layer::receive_data: Discard packet due to wrong comparison");
    return;
  } // else, continue
  const commsignia_layer::c2p_llc_hdr* l;
  int length;
  if ((ntohs(h->frame_ctrl) & 0xf000) == 0x8000) {
    l = (const commsignia_layer::c2p_llc_hdr*)(p + sizeof(commsignia_layer::c2p_recv) + sizeof(commsignia_layer::c2p_802_11p_hdr) + sizeof(commsignia_layer::c2p_qos_ctrl));
    length = sizeof(commsignia_layer::c2p_recv) + sizeof(commsignia_layer::c2p_802_11p_hdr) + sizeof(commsignia_layer::c2p_qos_ctrl) + sizeof(commsignia_layer::c2p_llc_hdr);
  } else {
    l = (const commsignia_layer::c2p_llc_hdr*)(p + sizeof(commsignia_layer::c2p_recv) + sizeof(commsignia_layer::c2p_802_11p_hdr));
    length = sizeof(commsignia_layer::c2p_recv) + sizeof(commsignia_layer::c2p_802_11p_hdr) + sizeof(commsignia_layer::c2p_llc_hdr);
  }
  //loggers::get_instance().log("commsignia_layer::receive_data: dsap=%02x", l->dsap);
  //loggers::get_instance().log("commsignia_layer::receive_data: ssap=%02x", l->ssap);
  //loggers::get_instance().log("commsignia_layer::receive_data: type=%04x", l->type);
  // Check ether type
  if ((_eth_type[1] == (unsigned char)((l->type & 0xff00) >> 8)) && (_eth_type[0] == (unsigned char)(l->type & 0xff))) { // Warning: Network ordered bytes
    // Extract payload
    data = OCTETSTRING(data.lengthof() - length, length + static_cast<const unsigned char *>(data));
    //loggers::get_instance().log_msg("commsignia_layer::receive_data: payload for upper layer:", data);
    
    // Update params
    CHARSTRING s = oct2str(dst);
    params[Params::mac_dst] = std::string(static_cast<const char *>(s));
    s = oct2str(src);
    params[Params::mac_src] = std::string(static_cast<const char *>(s));
    
    receive_to_all_layers(data, params);
  } // else, nothing to do
}

commsignia_layer_factory commsignia_layer_factory::_f;
