#ifndef CAMCODEC_H
#define CAMCODEC_H

#include "Codec.hh"
#include "per_code.hh"
#include "Params.hh"

class BITSTRING;   //! Forward declaration of TITAN class
class OCTETSTRING; //! Forward declaration of TITAN class

namespace CAM__PDU__Descriptions { //! Forward declaration of asn1c CAM class
  class CAM;
}

class CAMPDUCodec : public per_code <CAM__PDU__Descriptions::CAM>
{
public:
	explicit CAMPDUCodec() { };
  virtual int encode (const CAM__PDU__Descriptions::CAM& cam, BITSTRING& data);
  virtual int decode (const BITSTRING& data, CAM__PDU__Descriptions::CAM&);
};

class CAMCodec : public Codec<CAM__PDU__Descriptions::CAM, CAM__PDU__Descriptions::CAM>
{
  CAMPDUCodec asnCodec;

public:
  explicit CAMCodec() : Codec<CAM__PDU__Descriptions::CAM, CAM__PDU__Descriptions::CAM>(), asnCodec() { };
  virtual ~CAMCodec() { };

  virtual int encode (const CAM__PDU__Descriptions::CAM& cam, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, CAM__PDU__Descriptions::CAM&, Params* params = NULL);
};

#endif
