#pragma once

#include "ItsRSUsSimulator_TestSystem.hh"

#include "layer.hh"
#include "Params.hh"

namespace ItsRSUsSimulator__TestSystem {
  
  class ConfigRsuSimulatorPort : public ConfigRsuSimulatorPort_BASE {
    Params _cfg_params;
    Params _layer_params;
    layer* _layer;
    std::string _time_key;
    
  public:
    ConfigRsuSimulatorPort(const char *par_port_name);
    ~ConfigRsuSimulatorPort();

    void set_parameter(const char *parameter_name, const char *parameter_value);
    void receiveMsg (const BOOLEAN& p_ind, const Params& p_params);
    void receiveMsg (const LibItsGeoNetworking__TypesAndValues::UtGnInitialize& p_ind, const Params& p_params);
    void receiveMsg (const LibItsCam__TypesAndValues::UtCamInitialize& p_ind, const Params& p_params);
    void receiveMsg (const LibItsCam__TypesAndValues::UtCamTrigger& p_ind, const Params& p_params);
    void receiveMsg (const LibItsDenm__TypesAndValues::UtDenmInitialize& p_ind, const Params& p_params);
  
    /*void send(const CfInitialize& send_par, const COMPONENT& destination_component);
    void send(const CfInitialize& send_par);
    void send(const CfInitialize_template& send_par, const COMPONENT& destination_component);
    void send(const CfInitialize_template& send_par);
    void send(const BOOLEAN& send_par, const COMPONENT& destination_component);
    void send(const BOOLEAN& send_par);
    void send(const BOOLEAN_template& send_par, const COMPONENT& destination_component);
    void send(const BOOLEAN_template& send_par);
    void send(const LibItsGeoNetworking__TypesAndValues::UtGnResults& send_par, const COMPONENT& destination_component);
    void send(const LibItsGeoNetworking__TypesAndValues::UtGnResults& send_par);
    void send(const LibItsGeoNetworking__TypesAndValues::UtGnResults_template& send_par, const COMPONENT& destination_component);
    void send(const LibItsGeoNetworking__TypesAndValues::UtGnResults_template& send_par);*/
  
  private:
    /* void Handle_Fd_Event(int fd, boolean is_readable,
       boolean is_writable, boolean is_error); */
    void Handle_Fd_Event_Error(int fd);
    void Handle_Fd_Event_Writable(int fd);
    void Handle_Fd_Event_Readable(int fd);
    /* void Handle_Timeout(double time_since_last_call); */

  protected:
    void user_map(const char *system_port);
    void user_unmap(const char *system_port);

    void user_start();
    void user_stop();

    void outgoing_send(const CfInitialize& send_par);
    void outgoing_send(const BOOLEAN& send_par);
    void outgoing_send(const LibItsGeoNetworking__TypesAndValues::UtGnResults& send_par);
    void outgoing_send(const LibItsCam__TypesAndValues::UtCamResults& send_par);
    void outgoing_send(const LibItsDenm__TypesAndValues::UtDenmResults& send_par);
  }; // End of class ConfigRsuSimulatorPort

}
