/*!
 * \file      ConfigRsuSimulatorLayer.hh
 * \brief     Header file for ITS Configuration port protocol layer.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "t_layer.hh"
#include "ConfigRsuSimulatorCodec.hh"
#include "UpperTesterGnCodec.hh"
#include "UpperTesterCamCodec.hh"
#include "UpperTesterDenmCodec.hh"

namespace ItsRSUsSimulator__TestSystem {
  class ConfigRsuSimulatorPort;
  class CfInitialize;
}

class ConfigRsuSimulatorLayer : public t_layer<ItsRSUsSimulator__TestSystem::ConfigRsuSimulatorPort> {
  Params _params;
  ConfigRsuSimulatorCodec _codec;
  UpperTesterCamCodec _codec_cam; // FIXME Enhance all codec to encode inputs messages also

public:
  ConfigRsuSimulatorLayer() : t_layer<ItsRSUsSimulator__TestSystem::ConfigRsuSimulatorPort>(), _params(), _codec(), _codec_cam() {};
  ConfigRsuSimulatorLayer(const std::string& p_type, const std::string& param);
  virtual ~ConfigRsuSimulatorLayer() {};

  void sendMsg(const ItsRSUsSimulator__TestSystem::CfInitialize&, Params& params);
  void sendMsg(const LibItsGeoNetworking__TypesAndValues::UtGnResults& send_par, Params& params);
  void sendMsg(const LibItsCam__TypesAndValues::UtCamResults& send_par, Params& params);
  void sendMsg(const LibItsDenm__TypesAndValues::UtDenmResults& send_par, Params& params);
  
  virtual void send_data(OCTETSTRING& data, Params& params);
  virtual void receive_data(OCTETSTRING& data, Params& params);

private:
  int process_utinitialize_data(OCTETSTRING& data, Params& params);
  int process_ut_cam_changespeed_data(OCTETSTRING& data, Params& params);

}; // End of class ConfigRsuSimulatorLayer
