#include "ConfigRsuSimulatorLayerFactory.hh"

#include "loggers.hh"

#include "ItsRSUsSimulator_TestSystem.hh"

#include "UpperTesterCamCodec.hh"

ConfigRsuSimulatorLayer::ConfigRsuSimulatorLayer(const std::string & p_type, const std::string & param) : t_layer<ItsRSUsSimulator__TestSystem::ConfigRsuSimulatorPort>(p_type), _params(), _codec(), _codec_cam() {
  loggers::get_instance().log(">>> ConfigRsuSimulatorLayer::ConfigRsuSimulatorLayer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  Params::convert(_params, param);
}

void ConfigRsuSimulatorLayer::sendMsg(const ItsRSUsSimulator__TestSystem::CfInitialize& send_par, Params& params){
  loggers::get_instance().log_msg(">>> ConfigRsuSimulatorLayer::sendMsg: ", send_par);
  
  // Encode ConfigRsuSimulator PDU
  OCTETSTRING data;
  if (_codec.encode(static_cast<const Record_Type&>(send_par), data) == -1) {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::sendMsg: Encoding failure");
    return;
  }

  send_data(data, _params);
}

void ConfigRsuSimulatorLayer::sendMsg(const LibItsGeoNetworking__TypesAndValues::UtGnResults& send_par, Params& params) {
  loggers::get_instance().log_msg(">>> ConfigRsuSimulatorLayer::sendMsg: ", send_par);

  TTCN_Buffer encoding_buffer;
  if (send_par.ischosen(LibItsGeoNetworking__TypesAndValues::UtGnResults::ALT_utGnInitializeResult)) {
    encoding_buffer.put_c(0x01/*static_cast<const unsigned char>(UpperTesterGnCodec::c_utGnInitializeResult)*/);
    encoding_buffer.put_c((unsigned char)static_cast<const boolean>(send_par.utGnInitializeResult()));
  } else {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::sendMsg: Unsupported UtGnResults variant");
    return;
  }

  OCTETSTRING os(encoding_buffer.get_len(), encoding_buffer.get_data());
  send_data(os, _params);
}

void ConfigRsuSimulatorLayer::sendMsg(const LibItsCam__TypesAndValues::UtCamResults& send_par, Params& params) {
  loggers::get_instance().log_msg(">>> ConfigRsuSimulatorLayer::sendMsg: ", send_par);

  TTCN_Buffer encoding_buffer;
  if (send_par.ischosen(LibItsCam__TypesAndValues::UtCamResults::ALT_utCamInitializeResult)) {
    encoding_buffer.put_c(0x01/*static_cast<const unsigned char>(UpperTesterCamCodec::c_utCamInitializeResult)*/);
    encoding_buffer.put_c((unsigned char)static_cast<const boolean>(send_par.utCamInitializeResult()));
  } else {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::sendMsg: Unsupported UtCamResults variant");
    return;
  }

  OCTETSTRING os(encoding_buffer.get_len(), encoding_buffer.get_data());
  send_data(os, _params);
}

void ConfigRsuSimulatorLayer::sendMsg(const LibItsDenm__TypesAndValues::UtDenmResults& send_par, Params& params) {
  loggers::get_instance().log_msg(">>> ConfigRsuSimulatorLayer::sendMsg: ", send_par);

  TTCN_Buffer encoding_buffer;
  if (send_par.ischosen(LibItsDenm__TypesAndValues::UtDenmResults::ALT_utDenmInitializeResult)) {
    encoding_buffer.put_c(0x01/*static_cast<const unsigned char>(UpperTesterDenmCodec::c_utDenmInitializeResult)*/);
    encoding_buffer.put_c((unsigned char)static_cast<const boolean>(send_par.utDenmInitializeResult()));
  } else {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::sendMsg: Unsupported UtDenmResults variant");
    return;
  }

  OCTETSTRING os(encoding_buffer.get_len(), encoding_buffer.get_data());
  send_data(os, _params);
}

void ConfigRsuSimulatorLayer::send_data(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log_msg(">>> ConfigRsuSimulatorLayer::send_data: ", data);
  
  send_to_all_layers(data, params);
}

void ConfigRsuSimulatorLayer::receive_data(OCTETSTRING& data, Params& params)
{
  loggers::get_instance().log_msg(">>> ConfigRsuSimulatorLayer::receive_data: ", data);

  unsigned char id = *(static_cast<const unsigned char*>(data));
  if (id == 0x00) { // Receive an UtxxInitialise
    process_utinitialize_data(data, params);
  } else if (id == 0x00) { // Receive an UtCamChangeSpeed
    process_ut_cam_changespeed_data(data, params);
  } else {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::receive_data: Unsupported tag %02x", id);
  }
  
}

int ConfigRsuSimulatorLayer::process_utinitialize_data(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log("ConfigRsuSimulatorLayer::process_utinitialize_data");
  
  Params::const_iterator it = _params.find("ut");
  if (it == _params.cend()) {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::process_utinitialize_data: CF layer's ut parameter is missing");
    return -1;
  }

  if (_params[std::string("ut")].compare("gn") == 0) {
    OCTETSTRING hashedId(data.lengthof() - 1,  1 + static_cast<const unsigned char*>(data));
    LibItsGeoNetworking__TypesAndValues::UtGnInitialize p(hashedId);
    // Pass it to the ports if any
    to_all_upper_ports(p, params);
  } else if (_params[std::string("ut")].compare("cam") == 0) {
    OCTETSTRING hashedId(data.lengthof() - 1,  1 + static_cast<const unsigned char*>(data));
    LibItsCam__TypesAndValues::UtCamInitialize p(hashedId);
    // Pass it to the ports if any
    to_all_upper_ports(p, params);
  } else if (_params[std::string("ut")].compare("denm") == 0) {
    OCTETSTRING hashedId(data.lengthof() - 1,  1 + static_cast<const unsigned char*>(data));
    LibItsDenm__TypesAndValues::UtDenmInitialize p(hashedId);
    // Pass it to the ports if any
    to_all_upper_ports(p, params);
  } else {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::process_utinitialize_data: Unsupported protocol");
    return -1;
  }

  return 0;
}

int ConfigRsuSimulatorLayer::process_ut_cam_changespeed_data(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log("ConfigRsuSimulatorLayer::process_ut_cam_changespeed_data");

  Params::const_iterator it = _params.find("ut");
  if (it == _params.cend()) {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::process_ut_cam_changespeed_data: CF layer's ut parameter is missing");
    return -1;
  }

  if (_params[std::string("ut")].compare("cam") == 0) {
    OCTETSTRING speed(data.lengthof() - 1,  1 + static_cast<const unsigned char*>(data));
    LibItsCam__TypesAndValues::UtCamTrigger p;
    p.changeSpeed() = oct2int(speed);
    // Pass it to the ports if any
    to_all_upper_ports(p, params);
  } else {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::process_ut_cam_changespeed_data: Unsupported protocol");
    return -1;
  }

  return 0;
}

ConfigRsuSimulatorLayerFactory ConfigRsuSimulatorLayerFactory::_f;
