// This Test Port skeleton source file was generated by the
// TTCN-3 Compiler of the TTCN-3 Test Executor version CRL 113 200/5 R3A
// for U-ERICSSON\ethgry (ethgry@HU00078339) on Fri Aug 14 16:32:05 2015

// Copyright Ericsson Telecom AB 2000-2014

// You may modify this file. Complete the body of empty functions and
// add your member functions here.

#include "DenmPort.hh"
#include "denm_layer_factory.hh"
#include "loggers.hh"

namespace LibItsDenm__TestSystem {

  DenmPort::DenmPort(const char *par_port_name) : DenmPort_BASE(par_port_name), _cfg_params(), _layer_params(), _layer(NULL), _time_key("DenmPort::outgoing_send") {

  }

  DenmPort::~DenmPort()
  {
    if (_layer != NULL) {
      delete _layer;
    }
  }

  void DenmPort::set_parameter(const char * parameter_name, const char * parameter_value)
  {
    loggers::get_instance().log("DenmPort::set_parameter: %s=%s", parameter_name, parameter_value);
    _cfg_params.insert(std::pair<std::string, std::string>(std::string(parameter_name), std::string(parameter_value)));
  }

  /*void DenmPort::Handle_Fd_Event(int fd, boolean is_readable,
    boolean is_writable, boolean is_error) {}*/

  void DenmPort::Handle_Fd_Event_Error(int /*fd*/)
  {

  }

  void DenmPort::Handle_Fd_Event_Writable(int /*fd*/)
  {

  }

  void DenmPort::Handle_Fd_Event_Readable(int /*fd*/)
  {

  }

  /*void DenmPort::Handle_Timeout(double time_since_last_call) {}*/

  void DenmPort::user_map(const char * system_port)
  {
    loggers::get_instance().log(">>> DenmPort::user_map: %s", system_port);
    // Build layer stack
    std::map<std::string, std::string>::iterator it = _cfg_params.find(std::string("params"));
    if (it != _cfg_params.end()) {
      loggers::get_instance().log("DenmPort::user_map: %s", it->second.c_str());
      // Setup parameters
      Params::convert(_layer_params, it->second); // TODO This _layer_params seems to be useless
      // Create layer
      _layer = layer_stack_builder::get_instance()->create_layer_stack(it->second.c_str());
      if (static_cast<denm_layer *>(_layer) == NULL) {
	loggers::get_instance().error("DenmPort::user_map: Invalid stack configuration: %s", it->second.c_str());
      }
      static_cast<denm_layer *>(_layer)->add_upper_port(this);
    } else {
      loggers::get_instance().error("DenmPort::user_map: No layers defined in configuration file");
    }
  }

  void DenmPort::user_unmap(const char * system_port)
  {
    loggers::get_instance().log(">>> DenmPort::user_unmap: %s", system_port);
    if (_layer != NULL) {
      delete _layer;
      _layer = NULL;
    }
  }

  void DenmPort::user_start()
  {

  }

  void DenmPort::user_stop()
  {

  }

  void DenmPort::outgoing_send(const DenmReq& send_par)
  {
    loggers::get_instance().log_msg(">>> DenmPort::outgoing_send: payload=", send_par);
    
    float duration;
    loggers::get_instance().set_start_time(_time_key);
    Params params;
    static_cast<denm_layer *>(_layer)->sendMsg(send_par, params);
    loggers::get_instance().set_stop_time(_time_key, duration);
  }

  void DenmPort::receiveMsg(const LibItsDenm__TestSystem::DenmInd& p_ind, const Params& p_params) {
    loggers::get_instance().log_msg(">>> DenmPort::receive_msg: ", p_ind);

    incoming_message(p_ind);
  }

} /* end of namespace */

