package de.fraunhofer.sit.c2x.pki.ca.provider.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.mysql.jdbc.Statement;

import de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets.UserRole;
import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.Constants;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.HttpUser;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.HttpUserProvider;

public class JDBCHttpUserProvider extends AbstractMysqlConnection implements HttpUserProvider {

	@Override
	public String getName() {
		return "HttpUser provider";
	}

	@Override
	public HttpUser[] getAll(int offset, int limit) throws ProviderException {
		String sql = String.format("SELECT * FROM %s ORDER BY %s DESC LIMIT %d, %d",
				Constants.HTTP_USER__TABLE, Constants.HTTP_USER__COL__ID, offset, limit);
		Connection con = getConnection();
		PreparedStatement st = null;
		ResultSet result = null;
		try {
			st = con.prepareStatement(sql);
			st.execute();
			result = st.getResultSet();

			List<HttpUser> tmp = new ArrayList<>();
			while (result.next()) {

				HttpUser user = new HttpUser();
				user.setUser(result.getString(Constants.HTTP_USER__COL__ID));
				user.setRole(result.getString(Constants.HTTP_USER__COL__ROLE));
				user.setItsSRegPrefix(result.getBytes(Constants.HTTP_USER__COL__ITSS_REG_ID_PREFIX));
				user.setUser(result.getString(Constants.HTTP_USER__COL__ID));

				tmp.add(user);
			}
			return tmp.toArray(new HttpUser[tmp.size()]);
		} catch (SQLException e) {
			logger.error(e);
			throw new ProviderException(e);
		} finally {
			closeStatement(st);
			closeConnection(con);
			closeResultSet(result);
		}
	}

	@Override
	public UserRole getUserRole(String user, String password) {
		if (user != null && !user.isEmpty()) {
			String sql = String.format("SELECT %s FROM %s WHERE %s = ? AND %s = ?;",
					Constants.HTTP_USER__COL__ROLE, Constants.HTTP_USER__TABLE, Constants.HTTP_USER__COL__ID,
					Constants.HTTP_USER__COL__PASSWORD);
			Connection con = getConnection();
			PreparedStatement st = null;
			ResultSet result = null;
			try {
				st = con.prepareStatement(sql);
				st.setString(1, user);
				st.setString(2, password);
				st.execute();
				result = st.getResultSet();

				if (!result.first()) {
					logger.debug("User role not found for user= " + user + "");
				} else {
					return UserRole.valueOf(result.getString(Constants.HTTP_USER__COL__ROLE));
				}
			} catch (SQLException e) {
				logger.debug("invalid sql statement");
			} finally {
				closeStatement(st);
				closeConnection(con);
				closeResultSet(result);
			}
		}
		return null;

	}

	@Override
	public boolean save(HttpUser user) throws ProviderException {
		String sql = String.format("INSERT INTO %s (%s, %s, %s, %s) VALUES (?,?,?,?);",
				Constants.HTTP_USER__TABLE, Constants.HTTP_USER__COL__ID, Constants.HTTP_USER__COL__PASSWORD,
				Constants.HTTP_USER__COL__ROLE, Constants.HTTP_USER__COL__ITSS_REG_ID_PREFIX);
		Connection con = getConnection();
		PreparedStatement st = null;
		try {
			st = con.prepareStatement(sql);
			st.setString(1, user.getUser());
			st.setString(2, user.getPassword());
			st.setString(3, user.getRole());
			st.setBytes(4, user.getItsSRegPrefix());
			st.execute();

			return true;
		} catch (SQLException e) {
			logger.error("User not stored: " + e.getMessage());
			throw new ProviderException(e);
		} finally {
			closeStatement(st);
			closeConnection(con);
		}
	}

	@Override
	public int removeUser(String username) throws ProviderException {
		String sql = String.format("DELETE FROM %s WHERE %s = ?;", Constants.HTTP_USER__TABLE,
				Constants.HTTP_USER__COL__ID);
		Connection con = getConnection();
		PreparedStatement st = null;
		try {
			st = con.prepareStatement(sql, Statement.RETURN_GENERATED_KEYS);
			st.setString(1, username);
			return st.executeUpdate();
		} catch (SQLException e) {
			if (logger.isDebugEnabled())
				logger.debug("Cannot delete User: " + username, e);
			throw new ProviderException("Cannot delete User: " + username, e);
		} finally {
			closeStatement(st);
			closeConnection(con);
		}
	}

	@Override
	public HttpUser getUser(String username) {
		String sql = String.format("SELECT * FROM %s WHERE %s = ?;", Constants.HTTP_USER__TABLE,
				Constants.HTTP_USER__COL__ID);
		Connection con = getConnection();
		PreparedStatement st = null;
		ResultSet result = null;
		try {
			st = con.prepareStatement(sql);
			st.setString(1, username);
			st.execute();
			result = st.getResultSet();

			if (!result.first()) {
				//logger.debug("User role not found for user=" + username + ". Check your user name!");
			} else {
				return new HttpUser(result.getString(Constants.HTTP_USER__COL__ID),
						result.getString(Constants.HTTP_USER__COL__PASSWORD),
						result.getString(Constants.HTTP_USER__COL__ROLE),
						result.getBytes(Constants.HTTP_USER__COL__ITSS_REG_ID_PREFIX));
			}
		} catch (SQLException e) {
			logger.debug("invalid sql statement");
		} finally {
			closeStatement(st);
			closeConnection(con);
			closeResultSet(result);
		}
		return null;
	}

}
