/*************************************************************/
/* Copyright (C) 2016 OSS Nokalva, Inc.  All rights reserved.*/
/*************************************************************/

/* THIS FILE IS PROPRIETARY MATERIAL OF OSS NOKALVA, INC.
 * AND MAY BE USED ONLY BY DIRECT LICENSEES OF OSS NOKALVA, INC.
 * THIS FILE MAY NOT BE DISTRIBUTED.
 * THIS COPYRIGHT STATEMENT MAY NOT BE REMOVED. */

/* Generated for: Testing Technologies IST GmbH, Berlin, Germany - License 11335 on Linux */
/* Abstract syntax: iso_ts_24534-3 */
/* ASN.1 Java project: org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.Libitsivim_asn1 */
/* Created: Tue Jul 26 14:38:15 2016 */
/* ASN.1 Compiler for Java version: 6.2 */
/* ASN.1 compiler options and file names specified:
 * -output org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1 -nolistingfile
 * -nomodlistingfile -constraints -nouserconstraints -valuerefs -debug
 * -nopedantic -noinformatorymessages -uper -root -keepnames -norelaySafe
 * -noparamtypesuperclass -jiaapi -autoencdec -messageFormat emacs
 * /tmp/TTthree-2016.07.26.14.37.28.183/oss7811412611381924702gen/LibItsIvim_asn1.gen
 * asn/ISO_TS_14906_Generic.asn asn/ITS-Container.asn asn/ISO_TS_17419.asn
 * asn/ISO_TS_14906_Application.asn asn/ISO_TS_14816.asn asn/ISO_TS_19321.asn
 * asn/ISO_TS_24534-3.asn
 */


package org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_;

import com.oss.asn1.*;
import com.oss.metadata.*;

/**
 * Define the ASN1 Type ISO14823Code from ASN1 Module IVI_.
 * @see Sequence
 */

public class ISO14823Code extends Sequence {
    
    /**
     * The default constructor.
     */
    public ISO14823Code()
    {
    }
    
    /**
     * Construct with AbstractData components.
     */
    public ISO14823Code(PictogramCode pictogramCode, 
		    ISO14823Attributes attributes)
    {
	setPictogramCode(pictogramCode);
	setAttributes(attributes);
    }
    
    /**
     * Construct with required components.
     */
    public ISO14823Code(PictogramCode pictogramCode)
    {
	setPictogramCode(pictogramCode);
    }
    
    public void initComponents()
    {
	mComponents[0] = new PictogramCode();
	mComponents[1] = new ISO14823Attributes();
    }
    
    // Instance initializer
    {
	mComponents = new AbstractData[2];
    }
    
    // Method to create a specific component instance
    public AbstractData createInstance(int index)
    {
	switch (index) {
	    case 0:
		return new PictogramCode();
	    case 1:
		return new ISO14823Attributes();
	    default:
		throw new InternalError("AbstractCollection.createInstance()");
	}
	
    }
    
    
    // Methods for field "pictogramCode"
    public PictogramCode getPictogramCode()
    {
	return (PictogramCode)mComponents[0];
    }
    
    public void setPictogramCode(PictogramCode pictogramCode)
    {
	mComponents[0] = pictogramCode;
    }
    
    
    
    /**
     * Define the ASN1 Type PictogramCode from ASN1 Module IVI_.
     * @see Sequence
     */
    public static class PictogramCode extends Sequence {
	
	/**
	 * The default constructor.
	 */
	public PictogramCode()
	{
	}
	
	/**
	 * Construct with AbstractData components.
	 */
	public PictogramCode(OctetString countryCode, 
			ServiceCategoryCode serviceCategoryCode, 
			PictogramCategoryCode pictogramCategoryCode)
	{
	    setCountryCode(countryCode);
	    setServiceCategoryCode(serviceCategoryCode);
	    setPictogramCategoryCode(pictogramCategoryCode);
	}
	
	/**
	 * Construct with required components.
	 */
	public PictogramCode(ServiceCategoryCode serviceCategoryCode, 
			PictogramCategoryCode pictogramCategoryCode)
	{
	    setServiceCategoryCode(serviceCategoryCode);
	    setPictogramCategoryCode(pictogramCategoryCode);
	}
	
	public void initComponents()
	{
	    mComponents[0] = new OctetString();
	    mComponents[1] = new ServiceCategoryCode();
	    mComponents[2] = new PictogramCategoryCode();
	}
	
	// Instance initializer
	{
	    mComponents = new AbstractData[3];
	}
	
	// Method to create a specific component instance
	public AbstractData createInstance(int index)
	{
	    switch (index) {
		case 0:
		    return new OctetString();
		case 1:
		    return new ServiceCategoryCode();
		case 2:
		    return new PictogramCategoryCode();
		default:
		    throw new InternalError("AbstractCollection.createInstance()");
	    }
	    
	}
	
	
	// Methods for field "countryCode"
	public OctetString getCountryCode()
	{
	    return (OctetString)mComponents[0];
	}
	
	public void setCountryCode(OctetString countryCode)
	{
	    mComponents[0] = countryCode;
	}
	
	public boolean hasCountryCode()
	{
	    return componentIsPresent(0);
	}
	
	public void deleteCountryCode()
	{
	    setComponentAbsent(0);
	}
	
	
	// Methods for field "serviceCategoryCode"
	public ServiceCategoryCode getServiceCategoryCode()
	{
	    return (ServiceCategoryCode)mComponents[1];
	}
	
	public void setServiceCategoryCode(ServiceCategoryCode serviceCategoryCode)
	{
	    mComponents[1] = serviceCategoryCode;
	}
	
	
	
	/**
	 * Define the ASN1 Type ServiceCategoryCode from ASN1 Module IVI_.
	 * @see Choice
	 */
	public static class ServiceCategoryCode extends Choice {
	    
	    /**
	     * The default constructor.
	     */
	    public ServiceCategoryCode()
	    {
	    }
	    
	    public static final  int  trafficSignPictogram_chosen = 1;
	    public static final  int  publicFacilitiesPictogram_chosen = 2;
	    public static final  int  ambientOrRoadConditionPictogram_chosen = 3;
	    
	    // Methods for field "trafficSignPictogram"
	    public static ServiceCategoryCode createServiceCategoryCodeWithTrafficSignPictogram(TrafficSignPictogram trafficSignPictogram)
	    {
		ServiceCategoryCode __object = new ServiceCategoryCode();

		__object.setTrafficSignPictogram(trafficSignPictogram);
		return __object;
	    }
	    
	    public boolean hasTrafficSignPictogram()
	    {
		return getChosenFlag() == trafficSignPictogram_chosen;
	    }
	    
	    public TrafficSignPictogram getTrafficSignPictogram()
	    {
		if (hasTrafficSignPictogram())
		    return (TrafficSignPictogram)mChosenValue;
		else
		    return null;
	    }
	    
	    public void setTrafficSignPictogram(TrafficSignPictogram trafficSignPictogram)
	    {
		setChosenValue(trafficSignPictogram);
		setChosenFlag(trafficSignPictogram_chosen);
	    }
	    
	    
	    
	    /**
	     * Define the ASN1 Type TrafficSignPictogram from ASN1 Module IVI_.
	     * @see Enumerated
	     */
	    public static final class TrafficSignPictogram extends Enumerated {
		
		/**
		 * The default constructor.
		 */
		private TrafficSignPictogram()
		{
		    super(cFirstNumber);
		}
		
		protected TrafficSignPictogram(long value)
		{
		    super(value);
		}
		
		public static final class Value {
		    public static final long dangerWarning = 0;
		    public static final long regulatory = 1;
		    public static final long informative = 2;
		    
		}
		// Named list definitions.
		public static final TrafficSignPictogram dangerWarning =
		    new TrafficSignPictogram();
		public static final TrafficSignPictogram regulatory =
		    new TrafficSignPictogram(1);
		public static final TrafficSignPictogram informative =
		    new TrafficSignPictogram(2);
		private final static TrafficSignPictogram cNamedNumbers[] = {
		     dangerWarning, 
		     regulatory, 
		     informative
		};
		protected final static long cFirstNumber = 0;
		protected final static boolean cLinearNumbers = false;
		
		public Enumerated[] getNamedNumbers()
		{
		    return cNamedNumbers;
		}
		
		public boolean hasLinearNumbers()
		{
		    return cLinearNumbers;
		}
		
		public long getFirstNumber()
		{
		    return cFirstNumber;
		}
		
		public static TrafficSignPictogram valueOf(long value)
		{
		    return (TrafficSignPictogram)dangerWarning.lookupValue(value);
		}
		
		/**
		 * Initialize the type descriptor.
		 */
		private static final EnumeratedInfo c_typeinfo = new EnumeratedInfo (
		    new Tags (
			new short[] {
			    (short)0x8000
			}
		    ),
		    new QName (
			"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
			"ISO14823Code$PictogramCode$ServiceCategoryCode$TrafficSignPictogram"
		    ),
		    new QName (
			"builtin",
			"ENUMERATED"
		    ),
		    274462,
		    null,
		    new MemberList (
			new MemberListElement[] {
			    new MemberListElement (
				"dangerWarning",
				0
			    ),
			    new MemberListElement (
				"regulatory",
				1
			    ),
			    new MemberListElement (
				"informative",
				2
			    )
			}
		    ),
		    0,
		    dangerWarning
		);
		
		/**
		 * Get the type descriptor (TypeInfo) of 'this' TrafficSignPictogram object.
		 */
		public TypeInfo getTypeInfo()
		{
		    return c_typeinfo;
		}
		
		/**
		 * Get the static type descriptor (TypeInfo) of 'this' TrafficSignPictogram object.
		 */
		public static TypeInfo getStaticTypeInfo()
		{
		    return c_typeinfo;
		}
		
		/**
		 * Methods for "unknownEnumerator"
		 */
		private static final TrafficSignPictogram cUnknownEnumerator = 
		    new TrafficSignPictogram(-1);
		
		public boolean isUnknownEnumerator()
		{
		    return this == cUnknownEnumerator;
		}
		
		public Enumerated getUnknownEnumerator()
		{
		    return cUnknownEnumerator;
		}
		
	    } // End class definition for TrafficSignPictogram

	    // Methods for field "publicFacilitiesPictogram"
	    public static ServiceCategoryCode createServiceCategoryCodeWithPublicFacilitiesPictogram(PublicFacilitiesPictogram publicFacilitiesPictogram)
	    {
		ServiceCategoryCode __object = new ServiceCategoryCode();

		__object.setPublicFacilitiesPictogram(publicFacilitiesPictogram);
		return __object;
	    }
	    
	    public boolean hasPublicFacilitiesPictogram()
	    {
		return getChosenFlag() == publicFacilitiesPictogram_chosen;
	    }
	    
	    public PublicFacilitiesPictogram getPublicFacilitiesPictogram()
	    {
		if (hasPublicFacilitiesPictogram())
		    return (PublicFacilitiesPictogram)mChosenValue;
		else
		    return null;
	    }
	    
	    public void setPublicFacilitiesPictogram(PublicFacilitiesPictogram publicFacilitiesPictogram)
	    {
		setChosenValue(publicFacilitiesPictogram);
		setChosenFlag(publicFacilitiesPictogram_chosen);
	    }
	    
	    
	    
	    /**
	     * Define the ASN1 Type PublicFacilitiesPictogram from ASN1 Module IVI_.
	     * @see Enumerated
	     */
	    public static final class PublicFacilitiesPictogram extends Enumerated {
		
		/**
		 * The default constructor.
		 */
		private PublicFacilitiesPictogram()
		{
		    super(cFirstNumber);
		}
		
		protected PublicFacilitiesPictogram(long value)
		{
		    super(value);
		}
		
		public static final class Value {
		    public static final long publicFacilities = 0;
		    
		}
		// Named list definitions.
		public static final PublicFacilitiesPictogram publicFacilities =
		    new PublicFacilitiesPictogram(0);
		private final static PublicFacilitiesPictogram cNamedNumbers[] = {
		     publicFacilities
		};
		protected final static long cFirstNumber = 0;
		protected final static boolean cLinearNumbers = false;
		
		public Enumerated[] getNamedNumbers()
		{
		    return cNamedNumbers;
		}
		
		public boolean hasLinearNumbers()
		{
		    return cLinearNumbers;
		}
		
		public long getFirstNumber()
		{
		    return cFirstNumber;
		}
		
		public static PublicFacilitiesPictogram valueOf(long value)
		{
		    return (PublicFacilitiesPictogram)publicFacilities.lookupValue(value);
		}
		
		/**
		 * Initialize the type descriptor.
		 */
		private static final EnumeratedInfo c_typeinfo = new EnumeratedInfo (
		    new Tags (
			new short[] {
			    (short)0x8001
			}
		    ),
		    new QName (
			"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
			"ISO14823Code$PictogramCode$ServiceCategoryCode$PublicFacilitiesPictogram"
		    ),
		    new QName (
			"builtin",
			"ENUMERATED"
		    ),
		    274462,
		    null,
		    new MemberList (
			new MemberListElement[] {
			    new MemberListElement (
				"publicFacilities",
				0
			    )
			}
		    ),
		    0,
		    publicFacilities
		);
		
		/**
		 * Get the type descriptor (TypeInfo) of 'this' PublicFacilitiesPictogram object.
		 */
		public TypeInfo getTypeInfo()
		{
		    return c_typeinfo;
		}
		
		/**
		 * Get the static type descriptor (TypeInfo) of 'this' PublicFacilitiesPictogram object.
		 */
		public static TypeInfo getStaticTypeInfo()
		{
		    return c_typeinfo;
		}
		
		/**
		 * Methods for "unknownEnumerator"
		 */
		private static final PublicFacilitiesPictogram cUnknownEnumerator = 
		    new PublicFacilitiesPictogram(-1);
		
		public boolean isUnknownEnumerator()
		{
		    return this == cUnknownEnumerator;
		}
		
		public Enumerated getUnknownEnumerator()
		{
		    return cUnknownEnumerator;
		}
		
	    } // End class definition for PublicFacilitiesPictogram

	    // Methods for field "ambientOrRoadConditionPictogram"
	    public static ServiceCategoryCode createServiceCategoryCodeWithAmbientOrRoadConditionPictogram(AmbientOrRoadConditionPictogram ambientOrRoadConditionPictogram)
	    {
		ServiceCategoryCode __object = new ServiceCategoryCode();

		__object.setAmbientOrRoadConditionPictogram(ambientOrRoadConditionPictogram);
		return __object;
	    }
	    
	    public boolean hasAmbientOrRoadConditionPictogram()
	    {
		return getChosenFlag() == ambientOrRoadConditionPictogram_chosen;
	    }
	    
	    public AmbientOrRoadConditionPictogram getAmbientOrRoadConditionPictogram()
	    {
		if (hasAmbientOrRoadConditionPictogram())
		    return (AmbientOrRoadConditionPictogram)mChosenValue;
		else
		    return null;
	    }
	    
	    public void setAmbientOrRoadConditionPictogram(AmbientOrRoadConditionPictogram ambientOrRoadConditionPictogram)
	    {
		setChosenValue(ambientOrRoadConditionPictogram);
		setChosenFlag(ambientOrRoadConditionPictogram_chosen);
	    }
	    
	    
	    
	    /**
	     * Define the ASN1 Type AmbientOrRoadConditionPictogram from ASN1 Module IVI_.
	     * @see Enumerated
	     */
	    public static final class AmbientOrRoadConditionPictogram extends Enumerated {
		
		/**
		 * The default constructor.
		 */
		private AmbientOrRoadConditionPictogram()
		{
		    super(cFirstNumber);
		}
		
		protected AmbientOrRoadConditionPictogram(long value)
		{
		    super(value);
		}
		
		public static final class Value {
		    public static final long ambientCondition = 0;
		    public static final long roadCondition = 1;
		    
		}
		// Named list definitions.
		public static final AmbientOrRoadConditionPictogram ambientCondition =
		    new AmbientOrRoadConditionPictogram();
		public static final AmbientOrRoadConditionPictogram roadCondition =
		    new AmbientOrRoadConditionPictogram(1);
		private final static AmbientOrRoadConditionPictogram cNamedNumbers[] = {
		     ambientCondition, 
		     roadCondition
		};
		protected final static long cFirstNumber = 0;
		protected final static boolean cLinearNumbers = false;
		
		public Enumerated[] getNamedNumbers()
		{
		    return cNamedNumbers;
		}
		
		public boolean hasLinearNumbers()
		{
		    return cLinearNumbers;
		}
		
		public long getFirstNumber()
		{
		    return cFirstNumber;
		}
		
		public static AmbientOrRoadConditionPictogram valueOf(long value)
		{
		    return (AmbientOrRoadConditionPictogram)ambientCondition.lookupValue(value);
		}
		
		/**
		 * Initialize the type descriptor.
		 */
		private static final EnumeratedInfo c_typeinfo = new EnumeratedInfo (
		    new Tags (
			new short[] {
			    (short)0x8002
			}
		    ),
		    new QName (
			"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
			"ISO14823Code$PictogramCode$ServiceCategoryCode$AmbientOrRoadConditionPictogram"
		    ),
		    new QName (
			"builtin",
			"ENUMERATED"
		    ),
		    274462,
		    null,
		    new MemberList (
			new MemberListElement[] {
			    new MemberListElement (
				"ambientCondition",
				0
			    ),
			    new MemberListElement (
				"roadCondition",
				1
			    )
			}
		    ),
		    0,
		    ambientCondition
		);
		
		/**
		 * Get the type descriptor (TypeInfo) of 'this' AmbientOrRoadConditionPictogram object.
		 */
		public TypeInfo getTypeInfo()
		{
		    return c_typeinfo;
		}
		
		/**
		 * Get the static type descriptor (TypeInfo) of 'this' AmbientOrRoadConditionPictogram object.
		 */
		public static TypeInfo getStaticTypeInfo()
		{
		    return c_typeinfo;
		}
		
		/**
		 * Methods for "unknownEnumerator"
		 */
		private static final AmbientOrRoadConditionPictogram cUnknownEnumerator = 
		    new AmbientOrRoadConditionPictogram(-1);
		
		public boolean isUnknownEnumerator()
		{
		    return this == cUnknownEnumerator;
		}
		
		public Enumerated getUnknownEnumerator()
		{
		    return cUnknownEnumerator;
		}
		
	    } // End class definition for AmbientOrRoadConditionPictogram

	    // Method to create a specific choice instance
	    public AbstractData createInstance(int chosen)
	    {
		switch (chosen) {
		    case trafficSignPictogram_chosen:
			return TrafficSignPictogram.dangerWarning;
		    case publicFacilitiesPictogram_chosen:
			return PublicFacilitiesPictogram.publicFacilities;
		    case ambientOrRoadConditionPictogram_chosen:
			return AmbientOrRoadConditionPictogram.ambientCondition;
		    default:
			throw new InternalError("Choice.createInstance()");
		}
		
	    }
	    
	    /**
	     * Initialize the type descriptor.
	     */
	    private static final ChoiceInfo c_typeinfo = new ChoiceInfo (
		new Tags (
		    new short[] {
			(short)0x8001
		    }
		),
		new QName (
		    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
		    "ISO14823Code$PictogramCode$ServiceCategoryCode"
		),
		new QName (
		    "builtin",
		    "CHOICE"
		),
		274462,
		null,
		new Fields (
		    new FieldInfo[] {
			new FieldInfo (
			    new TypeInfoRef (
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
				    "ISO14823Code$PictogramCode$ServiceCategoryCode$TrafficSignPictogram"
				)
			    ),
			    "trafficSignPictogram",
			    0,
			    2
			),
			new FieldInfo (
			    new TypeInfoRef (
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
				    "ISO14823Code$PictogramCode$ServiceCategoryCode$PublicFacilitiesPictogram"
				)
			    ),
			    "publicFacilitiesPictogram",
			    1,
			    2
			),
			new FieldInfo (
			    new TypeInfoRef (
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
				    "ISO14823Code$PictogramCode$ServiceCategoryCode$AmbientOrRoadConditionPictogram"
				)
			    ),
			    "ambientOrRoadConditionPictogram",
			    2,
			    2
			)
		    }
		),
		0,
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8000, 0),
			new TagDecoderElement((short)0x8001, 1),
			new TagDecoderElement((short)0x8002, 2)
		    }
		)
	    );
	    
	    /**
	     * Get the type descriptor (TypeInfo) of 'this' ServiceCategoryCode object.
	     */
	    public TypeInfo getTypeInfo()
	    {
		return c_typeinfo;
	    }
	    
	    /**
	     * Get the static type descriptor (TypeInfo) of 'this' ServiceCategoryCode object.
	     */
	    public static TypeInfo getStaticTypeInfo()
	    {
		return c_typeinfo;
	    }
	    
	    /**
	     * Check the current selection on unknown extension
	     */
	    public final boolean hasUnknownExtension()
	    {
		return getChosenFlag() > 3;
	    }
	    
	} // End class definition for ServiceCategoryCode

	// Methods for field "pictogramCategoryCode"
	public PictogramCategoryCode getPictogramCategoryCode()
	{
	    return (PictogramCategoryCode)mComponents[2];
	}
	
	public void setPictogramCategoryCode(PictogramCategoryCode pictogramCategoryCode)
	{
	    mComponents[2] = pictogramCategoryCode;
	}
	
	
	
	/**
	 * Define the ASN1 Type PictogramCategoryCode from ASN1 Module IVI_.
	 * @see Sequence
	 */
	public static class PictogramCategoryCode extends Sequence {
	    
	    /**
	     * The default constructor.
	     */
	    public PictogramCategoryCode()
	    {
	    }
	    
	    /**
	     * Construct with AbstractData components.
	     */
	    public PictogramCategoryCode(INTEGER nature, INTEGER serialNumber)
	    {
		setNature(nature);
		setSerialNumber(serialNumber);
	    }
	    
	    /**
	     * Construct with components.
	     */
	    public PictogramCategoryCode(long nature, long serialNumber)
	    {
		this(new INTEGER(nature), new INTEGER(serialNumber));
	    }
	    
	    public void initComponents()
	    {
		mComponents[0] = new INTEGER();
		mComponents[1] = new INTEGER();
	    }
	    
	    // Instance initializer
	    {
		mComponents = new AbstractData[2];
	    }
	    
	    // Method to create a specific component instance
	    public AbstractData createInstance(int index)
	    {
		switch (index) {
		    case 0:
			return new INTEGER();
		    case 1:
			return new INTEGER();
		    default:
			throw new InternalError("AbstractCollection.createInstance()");
		}
		
	    }
	    
	    
	    // Methods for field "nature"
	    public long getNature()
	    {
		return ((INTEGER)mComponents[0]).longValue();
	    }
	    
	    public void setNature(long nature)
	    {
		setNature(new INTEGER(nature));
	    }
	    
	    public void setNature(INTEGER nature)
	    {
		mComponents[0] = nature;
	    }
	    
	    
	    // Methods for field "serialNumber"
	    public long getSerialNumber()
	    {
		return ((INTEGER)mComponents[1]).longValue();
	    }
	    
	    public void setSerialNumber(long serialNumber)
	    {
		setSerialNumber(new INTEGER(serialNumber));
	    }
	    
	    public void setSerialNumber(INTEGER serialNumber)
	    {
		mComponents[1] = serialNumber;
	    }
	    
	    
	    /**
	     * Initialize the type descriptor.
	     */
	    private static final SequenceInfo c_typeinfo = new SequenceInfo (
		new Tags (
		    new short[] {
			(short)0x8002
		    }
		),
		new QName (
		    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
		    "ISO14823Code$PictogramCode$PictogramCategoryCode"
		),
		new QName (
		    "builtin",
		    "SEQUENCE"
		),
		274458,
		null,
		new Fields (
		    new SequenceFieldInfo[] {
			new SequenceFieldInfo (
			    new TypeInfoRef (
				new IntegerInfo (
				    new Tags (
					new short[] {
					    (short)0x8000
					}
				    ),
				    new QName (
					"com.oss.asn1",
					"INTEGER"
				    ),
				    new QName (
					"builtin",
					"INTEGER"
				    ),
				    274458,
				    new ValueRangeConstraint (
					new AbstractBounds(
					    new com.oss.asn1.INTEGER(1), 
					    new com.oss.asn1.INTEGER(9),
					    0
					)
				    ),
				    new Bounds (
					new java.lang.Long(1),
					new java.lang.Long(9)
				    ),
				    null
				)
			    ),
			    "nature",
			    0,
			    2,
			    null
			),
			new SequenceFieldInfo (
			    new TypeInfoRef (
				new IntegerInfo (
				    new Tags (
					new short[] {
					    (short)0x8001
					}
				    ),
				    new QName (
					"com.oss.asn1",
					"INTEGER"
				    ),
				    new QName (
					"builtin",
					"INTEGER"
				    ),
				    274458,
				    new ValueRangeConstraint (
					new AbstractBounds(
					    new com.oss.asn1.INTEGER(0), 
					    new com.oss.asn1.INTEGER(99),
					    0
					)
				    ),
				    new Bounds (
					new java.lang.Long(0),
					new java.lang.Long(99)
				    ),
				    null
				)
			    ),
			    "serialNumber",
			    1,
			    2,
			    null
			)
		    }
		),
		0,
		new TagDecoders (
		    new TagDecoder[] {
			new TagDecoder (
			    new TagDecoderElement[] {
				new TagDecoderElement((short)0x8000, 0)
			    }
			),
			new TagDecoder (
			    new TagDecoderElement[] {
				new TagDecoderElement((short)0x8001, 1)
			    }
			)
		    }
		),
		0
	    );
	    
	    /**
	     * Get the type descriptor (TypeInfo) of 'this' PictogramCategoryCode object.
	     */
	    public TypeInfo getTypeInfo()
	    {
		return c_typeinfo;
	    }
	    
	    /**
	     * Get the static type descriptor (TypeInfo) of 'this' PictogramCategoryCode object.
	     */
	    public static TypeInfo getStaticTypeInfo()
	    {
		return c_typeinfo;
	    }
	    
	} // End class definition for PictogramCategoryCode

	/**
	 * Initialize the type descriptor.
	 */
	private static final SequenceInfo c_typeinfo = new SequenceInfo (
	    new Tags (
		new short[] {
		    (short)0x8000
		}
	    ),
	    new QName (
		"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
		"ISO14823Code$PictogramCode"
	    ),
	    new QName (
		"builtin",
		"SEQUENCE"
	    ),
	    274458,
	    null,
	    new Fields (
		new SequenceFieldInfo[] {
		    new SequenceFieldInfo (
			new TypeInfoRef (
			    new VectorInfo (
				new Tags (
				    new short[] {
					(short)0x8000
				    }
				),
				new QName (
				    "com.oss.asn1",
				    "OctetString"
				),
				new QName (
				    "builtin",
				    "OCTET STRING"
				),
				274458,
				new SizeConstraint (
				    new SingleValueConstraint (
					new com.oss.asn1.INTEGER(2)
				    )
				),
				new Bounds (
				    new java.lang.Long(2),
				    new java.lang.Long(2)
				)
			    )
			),
			"countryCode",
			0,
			3,
			null
		    ),
		    new SequenceFieldInfo (
			new TypeInfoRef (
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
				"ISO14823Code$PictogramCode$ServiceCategoryCode"
			    )
			),
			"serviceCategoryCode",
			1,
			2,
			null
		    ),
		    new SequenceFieldInfo (
			new TypeInfoRef (
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
				"ISO14823Code$PictogramCode$PictogramCategoryCode"
			    )
			),
			"pictogramCategoryCode",
			2,
			2,
			null
		    )
		}
	    ),
	    0,
	    new TagDecoders (
		new TagDecoder[] {
		    new TagDecoder (
			new TagDecoderElement[] {
			    new TagDecoderElement((short)0x8000, 0),
			    new TagDecoderElement((short)0x8001, 1)
			}
		    ),
		    new TagDecoder (
			new TagDecoderElement[] {
			    new TagDecoderElement((short)0x8001, 1)
			}
		    ),
		    new TagDecoder (
			new TagDecoderElement[] {
			    new TagDecoderElement((short)0x8002, 2)
			}
		    )
		}
	    ),
	    0
	);
	
	/**
	 * Get the type descriptor (TypeInfo) of 'this' PictogramCode object.
	 */
	public TypeInfo getTypeInfo()
	{
	    return c_typeinfo;
	}
	
	/**
	 * Get the static type descriptor (TypeInfo) of 'this' PictogramCode object.
	 */
	public static TypeInfo getStaticTypeInfo()
	{
	    return c_typeinfo;
	}
	
    } // End class definition for PictogramCode

    // Methods for field "attributes"
    public ISO14823Attributes getAttributes()
    {
	return (ISO14823Attributes)mComponents[1];
    }
    
    public void setAttributes(ISO14823Attributes attributes)
    {
	mComponents[1] = attributes;
    }
    
    public boolean hasAttributes()
    {
	return componentIsPresent(1);
    }
    
    public void deleteAttributes()
    {
	setComponentAbsent(1);
    }
    
    
    /**
     * Initialize the type descriptor.
     */
    private static final SequenceInfo c_typeinfo = new SequenceInfo (
	new Tags (
	    new short[] {
		0x0010
	    }
	),
	new QName (
	    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
	    "ISO14823Code"
	),
	new QName (
	    "IVI",
	    "ISO14823Code"
	),
	274458,
	null,
	new Fields (
	    new SequenceFieldInfo[] {
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new QName (
			    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
			    "ISO14823Code$PictogramCode"
			)
		    ),
		    "pictogramCode",
		    0,
		    2,
		    null
		),
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new ContainerInfo (
			    new Tags (
				new short[] {
				    (short)0x8001
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
				"ISO14823Attributes"
			    ),
			    new QName (
				"IVI",
				"ISO14823Attributes"
			    ),
			    274462,
			    new ExtensibleConstraint (
				new SizeConstraint (
				    new ValueRangeConstraint (
					new AbstractBounds(
					    new com.oss.asn1.INTEGER(1), 
					    new com.oss.asn1.INTEGER(8),
					    0
					)
				    )
				),
				null
			    ),
			    new Bounds (
				new java.lang.Long(1),
				new java.lang.Long(8)
			    ),
			    new TypeInfoRef (
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
				    "ISO14823Attributes$Choice_"
				)
			    )
			)
		    ),
		    "attributes",
		    1,
		    3,
		    null
		)
	    }
	),
	0,
	new TagDecoders (
	    new TagDecoder[] {
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8000, 0)
		    }
		),
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8001, 1)
		    }
		)
	    }
	),
	0
    );
    
    /**
     * Get the type descriptor (TypeInfo) of 'this' ISO14823Code object.
     */
    public TypeInfo getTypeInfo()
    {
	return c_typeinfo;
    }
    
    /**
     * Get the static type descriptor (TypeInfo) of 'this' ISO14823Code object.
     */
    public static TypeInfo getStaticTypeInfo()
    {
	return c_typeinfo;
    }
    
} // End class definition for ISO14823Code
