package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.PayloadTypeImpl.PayloadType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class Payload extends WaveElement {

	// ---- fields ----

	@Internal(order = 0)
	private PayloadType type;

	@Internal(order = 1)
	private Opaque data;

	// ---- constructors ----

	public Payload(DataInputStream in) throws IOException {
		type = PayloadTypeImpl.getInstance().getEnumType(in.readByte());
		if (type != PayloadType.SIGNED_EXTERNAL) {
			data = new Opaque(in);
		}
	}

	// ---- accept ----

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	// ---- getter ----

	public PayloadType getType() {
		return this.type;
	}

	public Opaque getData() {
		return this.data;
	}

	// ---- setter ----

	public void setType(PayloadType type) {
		this.type = type;
	}

	public void setData(Opaque data) {
		this.data = data;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		if (type == null)
			throw new IllegalArgumentException();
		int written = PayloadTypeImpl.getInstance().writeData(out, type);
		if (type != PayloadType.SIGNED_EXTERNAL) {
			if (data == null)
				throw new IllegalArgumentException("args may not be null");
			written += data.writeData(out);
		}
		return written;
	}
}