package de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets;

import java.io.IOException;

import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.jetty.security.authentication.SessionAuthentication;

import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.HtmlProvider;
import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.HttpUser;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.HttpUserProvider;

/**
 * A simple servlet that outputs the content of the configuration stored in the
 * DB
 * 
 * @author Norbert Bissmeyer (norbert.bissmeyer@sit.fraunhofer.de)
 * 
 */
public class UserServlet extends AbstractServlet {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public static final String URL = "/user";
	public static final String TITLE = "Add http user";
	public static final String DATE_PATTERN_LOG = "yyyy-MM-dd HH:mm:ss,SSS";

	private final HttpUserProvider httpUserProvider;

	@Inject
	public UserServlet(HtmlProvider htmlProvider, HttpUserProvider httpUserProvider) {
		super(htmlProvider);
		this.httpUserProvider = httpUserProvider;
	}

	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException,
			IOException {
		String userInfo = "";

		try {
			if ((req.getParameter("username") != null && req.getParameter("username").length() > 0)
					|| (req.getParameter("password") != null && req.getParameter("password").length() > 0)
					&& req.getParameter("role") != null && req.getParameter("role").length() > 0
					&& req.getParameter("itsSRegPrefix") != null
					&& req.getParameter("itsSRegPrefix").length() > 0) {
				HttpUser user = new HttpUser();

				String username = req.getParameter("username");
				user.setUser(username);

				String password = req.getParameter("password");
				user.setPassword(password);

				String role = req.getParameter("role");
				user.setRole(role);

				String itsSRegPrefixString = req.getParameter("itsSRegPrefix");
				if (itsSRegPrefixString != null && itsSRegPrefixString.length() > 0) {
					user.setItsSRegPrefix(Hex.decodeHex(itsSRegPrefixString.toCharArray()));
				}

				httpUserProvider.save(user);

				// get user from http session
				SessionAuthentication userLoggedIn = (SessionAuthentication) req.getSession().getAttribute(
						SessionAuthentication.__J_AUTHENTICATED);
				logger.info("USER: User "
						+ userLoggedIn.getUserIdentity().getUserPrincipal().getName().toString()
						+ " registered a new http user: " + username);

				userInfo = "<div id=\"ackbox\">Http user with name " + username + " and role " + role
						+ " inserted in database</div>";
			} else if (req.getParameter("submit") != null) {
				if (userInfo.isEmpty())
					userInfo = "<div id=\"errorbox\">Please provide all required elements</div>";
			}
		} catch (NumberFormatException | DecoderException | ProviderException e) {
			userInfo = "<div id=\"errorbox\">Unable to insert http user with name "
					+ req.getParameter("username") + " in database</div>";
		}
		response.sendRedirect(URL + "?userInfo=" + userInfo);
	}

	@Override
	public String getUrl() {
		return URL;
	}

	@Override
	public String getTitle() {
		return TITLE;
	}

	@Override
	protected String contentHtml(HttpServletRequest req, HttpServletResponse resp) {

		StringBuilder sb = new StringBuilder();
		String userInfo = "";

		if (req.getParameter("userInfo") != null && req.getParameter("userInfo").length() > 0) {
			userInfo = req.getParameter("userInfo");
		}

		if (userInfo != "")
			sb.append(userInfo);

		sb.append("<form name=\"httpUserForm\" action=\"\" method=\"post\">\n");
		sb.append("<table>\n");

		sb.append("<tr><td>Email address*:</td><td><input id=\"username\" name=\"username\" style=\"width:400px\" maxlength=\"200\" /></td></tr>\n");
		sb.append("<tr><td>Password*:</td><td><input id=\"password\" name=\"password\" style=\"width:400px\" maxlength=\"200\" /></td></tr>\n");
		sb.append("<tr><td>Role*:</td><td><select id=\"role\" name=\"role\" style=\"width:400px\">");
		for (UserRole role : UserRole.getAllRoles()) {
			sb.append("<option value=\"" + role.toString() + "\" ");
			if (role == UserRole.REGISTRATION_USER)
				sb.append("selected= \"selected\"");
			sb.append(">" + role.toString() + "</option>");
		}
		sb.append("</select></td></tr>\n");
		sb.append("<tr><td>ITS-S registration prefix (hex encoded)*:</td><td><input id=\"itsSRegPrefix\" name=\"itsSRegPrefix\" style=\"width:400px\" maxlength=\"16\" /></td></tr>\n");

		sb.append("<tr><td></td><td><br /><input type=\"submit\" value=\"Insert\" /></td></tr>\n"
				+ "</table>\n");
		sb.append("</form>\n");
		sb.append("<br/>\nRequired elements are marked by a *\n");

		return sb.toString();
	}

	@Override
	public boolean isProtected() {
		return true;
	}

	@Override
	public String[] getAllowedRoles() {
		return new String[] { UserRole.ADMINISTRATOR.toString() };
	}

	@Override
	public Category getCategory() {
		return Category.SETUP;
	}
}
