/*************************************************************/
/* Copyright (C) 2015 OSS Nokalva, Inc.  All rights reserved.*/
/*************************************************************/

/* THIS FILE IS PROPRIETARY MATERIAL OF OSS NOKALVA, INC.
 * AND MAY BE USED ONLY BY DIRECT LICENSEES OF OSS NOKALVA, INC.
 * THIS FILE MAY NOT BE DISTRIBUTED. */

/* Generated for: Testing Technologies IST GmbH, Berlin, Germany - License 11335 on Linux */
/* Abstract syntax: dsrc_reg_d */
/* ASN.1 Java project: org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.Libitsmapspat_asn1 */
/* Created: Mon Feb  9 16:50:07 2015 */
/* ASN.1 Compiler for Java version: 5.1.0.2 */
/* ASN.1 compiler options and file names specified:
 * -output org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1
 * -nolistingfile -nomodlistingfile -constraints -nouserconstraints -valuerefs
 * -debug -nopedantic -noinformatorymessages -uper -root -keepnames
 * -norelaySafe -noparamtypesuperclass -jiaapi -autoencdec -messageFormat emacs
 * /tmp/TTthree-2015.02.09.16.49.37.896/oss6894826343771225846gen/LibItsMapSpat_asn1.gen
 * asn/ITS-Container.asn asn/REG_D.asn asn/MAP_SPAT_ETSI.asn
 * asn/DSRC_REG_D.asn
 */


package org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc;

import com.oss.asn1.*;
import com.oss.metadata.*;

/**
 * Define the ASN1 Type ComputedLane from ASN1 Module DSRC.
 * @see Sequence
 */

public class ComputedLane extends Sequence {
    
    /**
     * The default constructor.
     */
    public ComputedLane()
    {
    }
    
    /**
     * Construct with AbstractData components.
     */
    public ComputedLane(LaneID referenceLaneId, OffsetXaxis offsetXaxis, 
		    OffsetYaxis offsetYaxis, Angle rotateXY, 
		    Scale_B12 scaleXaxis, Scale_B12 scaleYaxis, 
		    RegionalComputedLane regional)
    {
	setReferenceLaneId(referenceLaneId);
	setOffsetXaxis(offsetXaxis);
	setOffsetYaxis(offsetYaxis);
	setRotateXY(rotateXY);
	setScaleXaxis(scaleXaxis);
	setScaleYaxis(scaleYaxis);
	setRegional(regional);
    }
    
    /**
     * Construct with required components.
     */
    public ComputedLane(LaneID referenceLaneId, OffsetXaxis offsetXaxis, 
		    OffsetYaxis offsetYaxis)
    {
	setReferenceLaneId(referenceLaneId);
	setOffsetXaxis(offsetXaxis);
	setOffsetYaxis(offsetYaxis);
    }
    
    public void initComponents()
    {
	mComponents[0] = new LaneID();
	mComponents[1] = new OffsetXaxis();
	mComponents[2] = new OffsetYaxis();
	mComponents[3] = new Angle();
	mComponents[4] = new Scale_B12();
	mComponents[5] = new Scale_B12();
	mComponents[6] = new RegionalComputedLane();
    }
    
    // Instance initializer
    {
	mComponents = new AbstractData[7];
    }
    
    // Method to create a specific component instance
    public AbstractData createInstance(int index)
    {
	switch (index) {
	    case 0:
		return new LaneID();
	    case 1:
		return new OffsetXaxis();
	    case 2:
		return new OffsetYaxis();
	    case 3:
		return new Angle();
	    case 4:
		return new Scale_B12();
	    case 5:
		return new Scale_B12();
	    case 6:
		return new RegionalComputedLane();
	    default:
		throw new InternalError("AbstractCollection.createInstance()");
	}
	
    }
    
    
    // Methods for field "referenceLaneId"
    public LaneID getReferenceLaneId()
    {
	return (LaneID)mComponents[0];
    }
    
    public void setReferenceLaneId(LaneID referenceLaneId)
    {
	mComponents[0] = referenceLaneId;
    }
    
    
    // Methods for field "offsetXaxis"
    public OffsetXaxis getOffsetXaxis()
    {
	return (OffsetXaxis)mComponents[1];
    }
    
    public void setOffsetXaxis(OffsetXaxis offsetXaxis)
    {
	mComponents[1] = offsetXaxis;
    }
    
    
    
    /**
     * Define the ASN1 Type OffsetXaxis from ASN1 Module DSRC.
     * @see Choice
     */
    public static class OffsetXaxis extends Choice {
	
	/**
	 * The default constructor.
	 */
	public OffsetXaxis()
	{
	}
	
	public static final  int  small_chosen = 1;
	public static final  int  large_chosen = 2;
	
	// Methods for field "small"
	public static OffsetXaxis createOffsetXaxisWithSmall(long small)
	{
	    return createOffsetXaxisWithSmall(new DrivenLineOffsetSm(small));
	}
	
	public static OffsetXaxis createOffsetXaxisWithSmall(DrivenLineOffsetSm small)
	{
	    OffsetXaxis __object = new OffsetXaxis();

	    __object.setSmall(small);
	    return __object;
	}
	
	public boolean hasSmall()
	{
	    return getChosenFlag() == small_chosen;
	}
	
	public void setSmall(long small)
	{
	    setSmall(new DrivenLineOffsetSm(small));
	}
	
	public void setSmall(DrivenLineOffsetSm small)
	{
	    setChosenValue(small);
	    setChosenFlag(small_chosen);
	}
	
	
	// Methods for field "large"
	public static OffsetXaxis createOffsetXaxisWithLarge(long large)
	{
	    return createOffsetXaxisWithLarge(new DrivenLineOffsetLg(large));
	}
	
	public static OffsetXaxis createOffsetXaxisWithLarge(DrivenLineOffsetLg large)
	{
	    OffsetXaxis __object = new OffsetXaxis();

	    __object.setLarge(large);
	    return __object;
	}
	
	public boolean hasLarge()
	{
	    return getChosenFlag() == large_chosen;
	}
	
	public void setLarge(long large)
	{
	    setLarge(new DrivenLineOffsetLg(large));
	}
	
	public void setLarge(DrivenLineOffsetLg large)
	{
	    setChosenValue(large);
	    setChosenFlag(large_chosen);
	}
	
	
	// Method to create a specific choice instance
	public AbstractData createInstance(int chosen)
	{
	    switch (chosen) {
		case small_chosen:
		    return new DrivenLineOffsetSm();
		case large_chosen:
		    return new DrivenLineOffsetLg();
		default:
		    throw new InternalError("Choice.createInstance()");
	    }
	    
	}
	
	/**
	 * Initialize the type descriptor.
	 */
	private static final ChoiceInfo c_typeinfo = new ChoiceInfo (
	    new Tags (
		new short[] {
		    (short)0x8001
		}
	    ),
	    new QName (
		"org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
		"ComputedLane$OffsetXaxis"
	    ),
	    new QName (
		"builtin",
		"CHOICE"
	    ),
	    12314,
	    null,
	    new Fields (
		new FieldInfo[] {
		    new FieldInfo (
			new TypeInfoRef (
			    new IntegerInfo (
				new Tags (
				    new short[] {
					(short)0x8000
				    }
				),
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				    "DrivenLineOffsetSm"
				),
				new QName (
				    "DSRC",
				    "DrivenLineOffsetSm"
				),
				12314,
				new ValueRangeConstraint (
				    new AbstractBounds(
					new DrivenLineOffsetSm(-2047), 
					new DrivenLineOffsetSm(2047),
					0
				    )
				),
				new Bounds (
				    new java.lang.Long(-2047),
				    new java.lang.Long(2047)
				),
				null
			    )
			),
			"small",
			0,
			2
		    ),
		    new FieldInfo (
			new TypeInfoRef (
			    new IntegerInfo (
				new Tags (
				    new short[] {
					(short)0x8001
				    }
				),
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				    "DrivenLineOffsetLg"
				),
				new QName (
				    "DSRC",
				    "DrivenLineOffsetLg"
				),
				12314,
				new ValueRangeConstraint (
				    new AbstractBounds(
					new DrivenLineOffsetLg(-32767), 
					new DrivenLineOffsetLg(32767),
					0
				    )
				),
				new Bounds (
				    new java.lang.Long(-32767),
				    new java.lang.Long(32767)
				),
				null
			    )
			),
			"large",
			1,
			2
		    )
		}
	    ),
	    0,
	    new TagDecoder (
		new TagDecoderElement[] {
		    new TagDecoderElement((short)0x8000, 0),
		    new TagDecoderElement((short)0x8001, 1)
		}
	    )
	);
	
	/**
	 * Get the type descriptor (TypeInfo) of 'this' OffsetXaxis object.
	 */
	public TypeInfo getTypeInfo()
	{
	    return c_typeinfo;
	}
	
	/**
	 * Get the static type descriptor (TypeInfo) of 'this' OffsetXaxis object.
	 */
	public static TypeInfo getStaticTypeInfo()
	{
	    return c_typeinfo;
	}
	
    } // End class definition for OffsetXaxis

    // Methods for field "offsetYaxis"
    public OffsetYaxis getOffsetYaxis()
    {
	return (OffsetYaxis)mComponents[2];
    }
    
    public void setOffsetYaxis(OffsetYaxis offsetYaxis)
    {
	mComponents[2] = offsetYaxis;
    }
    
    
    
    /**
     * Define the ASN1 Type OffsetYaxis from ASN1 Module DSRC.
     * @see Choice
     */
    public static class OffsetYaxis extends Choice {
	
	/**
	 * The default constructor.
	 */
	public OffsetYaxis()
	{
	}
	
	public static final  int  small_chosen = 1;
	public static final  int  large_chosen = 2;
	
	// Methods for field "small"
	public static OffsetYaxis createOffsetYaxisWithSmall(long small)
	{
	    return createOffsetYaxisWithSmall(new DrivenLineOffsetSm(small));
	}
	
	public static OffsetYaxis createOffsetYaxisWithSmall(DrivenLineOffsetSm small)
	{
	    OffsetYaxis __object = new OffsetYaxis();

	    __object.setSmall(small);
	    return __object;
	}
	
	public boolean hasSmall()
	{
	    return getChosenFlag() == small_chosen;
	}
	
	public void setSmall(long small)
	{
	    setSmall(new DrivenLineOffsetSm(small));
	}
	
	public void setSmall(DrivenLineOffsetSm small)
	{
	    setChosenValue(small);
	    setChosenFlag(small_chosen);
	}
	
	
	// Methods for field "large"
	public static OffsetYaxis createOffsetYaxisWithLarge(long large)
	{
	    return createOffsetYaxisWithLarge(new DrivenLineOffsetLg(large));
	}
	
	public static OffsetYaxis createOffsetYaxisWithLarge(DrivenLineOffsetLg large)
	{
	    OffsetYaxis __object = new OffsetYaxis();

	    __object.setLarge(large);
	    return __object;
	}
	
	public boolean hasLarge()
	{
	    return getChosenFlag() == large_chosen;
	}
	
	public void setLarge(long large)
	{
	    setLarge(new DrivenLineOffsetLg(large));
	}
	
	public void setLarge(DrivenLineOffsetLg large)
	{
	    setChosenValue(large);
	    setChosenFlag(large_chosen);
	}
	
	
	// Method to create a specific choice instance
	public AbstractData createInstance(int chosen)
	{
	    switch (chosen) {
		case small_chosen:
		    return new DrivenLineOffsetSm();
		case large_chosen:
		    return new DrivenLineOffsetLg();
		default:
		    throw new InternalError("Choice.createInstance()");
	    }
	    
	}
	
	/**
	 * Initialize the type descriptor.
	 */
	private static final ChoiceInfo c_typeinfo = new ChoiceInfo (
	    new Tags (
		new short[] {
		    (short)0x8002
		}
	    ),
	    new QName (
		"org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
		"ComputedLane$OffsetYaxis"
	    ),
	    new QName (
		"builtin",
		"CHOICE"
	    ),
	    12314,
	    null,
	    new Fields (
		new FieldInfo[] {
		    new FieldInfo (
			new TypeInfoRef (
			    new IntegerInfo (
				new Tags (
				    new short[] {
					(short)0x8000
				    }
				),
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				    "DrivenLineOffsetSm"
				),
				new QName (
				    "DSRC",
				    "DrivenLineOffsetSm"
				),
				12314,
				new ValueRangeConstraint (
				    new AbstractBounds(
					new DrivenLineOffsetSm(-2047), 
					new DrivenLineOffsetSm(2047),
					0
				    )
				),
				new Bounds (
				    new java.lang.Long(-2047),
				    new java.lang.Long(2047)
				),
				null
			    )
			),
			"small",
			0,
			2
		    ),
		    new FieldInfo (
			new TypeInfoRef (
			    new IntegerInfo (
				new Tags (
				    new short[] {
					(short)0x8001
				    }
				),
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				    "DrivenLineOffsetLg"
				),
				new QName (
				    "DSRC",
				    "DrivenLineOffsetLg"
				),
				12314,
				new ValueRangeConstraint (
				    new AbstractBounds(
					new DrivenLineOffsetLg(-32767), 
					new DrivenLineOffsetLg(32767),
					0
				    )
				),
				new Bounds (
				    new java.lang.Long(-32767),
				    new java.lang.Long(32767)
				),
				null
			    )
			),
			"large",
			1,
			2
		    )
		}
	    ),
	    0,
	    new TagDecoder (
		new TagDecoderElement[] {
		    new TagDecoderElement((short)0x8000, 0),
		    new TagDecoderElement((short)0x8001, 1)
		}
	    )
	);
	
	/**
	 * Get the type descriptor (TypeInfo) of 'this' OffsetYaxis object.
	 */
	public TypeInfo getTypeInfo()
	{
	    return c_typeinfo;
	}
	
	/**
	 * Get the static type descriptor (TypeInfo) of 'this' OffsetYaxis object.
	 */
	public static TypeInfo getStaticTypeInfo()
	{
	    return c_typeinfo;
	}
	
    } // End class definition for OffsetYaxis

    // Methods for field "rotateXY"
    public Angle getRotateXY()
    {
	return (Angle)mComponents[3];
    }
    
    public void setRotateXY(Angle rotateXY)
    {
	mComponents[3] = rotateXY;
    }
    
    public boolean hasRotateXY()
    {
	return componentIsPresent(3);
    }
    
    public void deleteRotateXY()
    {
	setComponentAbsent(3);
    }
    
    
    // Methods for field "scaleXaxis"
    public Scale_B12 getScaleXaxis()
    {
	return (Scale_B12)mComponents[4];
    }
    
    public void setScaleXaxis(Scale_B12 scaleXaxis)
    {
	mComponents[4] = scaleXaxis;
    }
    
    public boolean hasScaleXaxis()
    {
	return componentIsPresent(4);
    }
    
    public void deleteScaleXaxis()
    {
	setComponentAbsent(4);
    }
    
    
    // Methods for field "scaleYaxis"
    public Scale_B12 getScaleYaxis()
    {
	return (Scale_B12)mComponents[5];
    }
    
    public void setScaleYaxis(Scale_B12 scaleYaxis)
    {
	mComponents[5] = scaleYaxis;
    }
    
    public boolean hasScaleYaxis()
    {
	return componentIsPresent(5);
    }
    
    public void deleteScaleYaxis()
    {
	setComponentAbsent(5);
    }
    
    
    // Methods for field "regional"
    public RegionalComputedLane getRegional()
    {
	return (RegionalComputedLane)mComponents[6];
    }
    
    public void setRegional(RegionalComputedLane regional)
    {
	mComponents[6] = regional;
    }
    
    public boolean hasRegional()
    {
	return componentIsPresent(6);
    }
    
    public void deleteRegional()
    {
	setComponentAbsent(6);
    }
    
    
    /**
     * Initialize the type descriptor.
     */
    private static final SequenceInfo c_typeinfo = new SequenceInfo (
	new Tags (
	    new short[] {
		0x0010
	    }
	),
	new QName (
	    "org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
	    "ComputedLane"
	),
	new QName (
	    "DSRC",
	    "ComputedLane"
	),
	12318,
	null,
	new Fields (
	    new SequenceFieldInfo[] {
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8000
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				"LaneID"
			    ),
			    new QName (
				"DSRC",
				"LaneID"
			    ),
			    12314,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new LaneID(0), 
				    new LaneID(255),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(0),
				new java.lang.Long(255)
			    ),
			    null
			)
		    ),
		    "referenceLaneId",
		    0,
		    2,
		    null
		),
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new QName (
			    "org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
			    "ComputedLane$OffsetXaxis"
			)
		    ),
		    "offsetXaxis",
		    1,
		    2,
		    null
		),
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new QName (
			    "org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
			    "ComputedLane$OffsetYaxis"
			)
		    ),
		    "offsetYaxis",
		    2,
		    2,
		    null
		),
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8003
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				"Angle"
			    ),
			    new QName (
				"DSRC",
				"Angle"
			    ),
			    12314,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new Angle(0), 
				    new Angle(28800),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(0),
				new java.lang.Long(28800)
			    ),
			    null
			)
		    ),
		    "rotateXY",
		    3,
		    3,
		    null
		),
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8004
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				"Scale_B12"
			    ),
			    new QName (
				"DSRC",
				"Scale-B12"
			    ),
			    12314,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new Scale_B12(-2048), 
				    new Scale_B12(2047),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(-2048),
				new java.lang.Long(2047)
			    ),
			    null
			)
		    ),
		    "scaleXaxis",
		    4,
		    3,
		    null
		),
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8005
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				"Scale_B12"
			    ),
			    new QName (
				"DSRC",
				"Scale-B12"
			    ),
			    12314,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new Scale_B12(-2048), 
				    new Scale_B12(2047),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(-2048),
				new java.lang.Long(2047)
			    ),
			    null
			)
		    ),
		    "scaleYaxis",
		    5,
		    3,
		    null
		),
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new SequenceInfo (
			    new Tags (
				new short[] {
				    (short)0x8006
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				"RegionalComputedLane"
			    ),
			    new QName (
				"DSRC",
				"RegionalComputedLane"
			    ),
			    12318,
			    null,
			    new FieldsRef (
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				    "RegionalComputedLane"
				)
			    ),
			    0,
			    null,
			    0
			)
		    ),
		    "regional",
		    6,
		    3,
		    null
		)
	    }
	),
	0,
	new TagDecoders (
	    new TagDecoder[] {
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8000, 0)
		    }
		),
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8001, 1)
		    }
		),
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8002, 2)
		    }
		),
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8003, 3),
			new TagDecoderElement((short)0x8004, 4),
			new TagDecoderElement((short)0x8005, 5),
			new TagDecoderElement((short)0x8006, 6)
		    }
		),
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8004, 4),
			new TagDecoderElement((short)0x8005, 5),
			new TagDecoderElement((short)0x8006, 6)
		    }
		),
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8005, 5),
			new TagDecoderElement((short)0x8006, 6)
		    }
		),
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8006, 6)
		    }
		)
	    }
	),
	0
    );
    
    /**
     * Get the type descriptor (TypeInfo) of 'this' ComputedLane object.
     */
    public TypeInfo getTypeInfo()
    {
	return c_typeinfo;
    }
    
    /**
     * Get the static type descriptor (TypeInfo) of 'this' ComputedLane object.
     */
    public static TypeInfo getStaticTypeInfo()
    {
	return c_typeinfo;
    }
    
} // End class definition for ComputedLane
