/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi;

import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammars.Grammars;
import com.siemens.ct.exi.grammars.SchemaInformedGrammars;
import com.siemens.ct.exi.grammars.SchemaLessGrammars;
import com.siemens.ct.exi.grammars.XSDGrammarsBuilder;
import java.io.InputStream;

public class GrammarFactory {
    protected XSDGrammarsBuilder grammarBuilder = XSDGrammarsBuilder.newInstance();

    protected GrammarFactory() {
    }

    public static GrammarFactory newInstance() {
        return new GrammarFactory();
    }

    public Grammars createGrammars(String xsdLocation) throws EXIException {
        if (xsdLocation == null || xsdLocation.equals("")) {
            throw new EXIException("SchemaLocation not specified correctly!");
        }
        this.grammarBuilder.loadGrammars(xsdLocation);
        SchemaInformedGrammars g = this.grammarBuilder.toGrammars();
        g.setSchemaId(xsdLocation);
        return g;
    }

    public Grammars createGrammars(InputStream is) throws EXIException {
        this.grammarBuilder.loadGrammars(is);
        SchemaInformedGrammars g = this.grammarBuilder.toGrammars();
        g.setSchemaId("No-Schema-ID-Set");
        return g;
    }

    public Grammars createXSDTypesOnlyGrammars() throws EXIException {
        this.grammarBuilder.loadXSDTypesOnlyGrammars();
        SchemaInformedGrammars g = this.grammarBuilder.toGrammars();
        g.setBuiltInXMLSchemaTypesOnly(true);
        return g;
    }

    public Grammars createSchemaLessGrammars() {
        return new SchemaLessGrammars();
    }
}

