/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.voip;

import java.util.ArrayList;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JMappedHeader;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.RegistryHeaderErrors;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;

@Header
public class Sdp
extends JMappedHeader {
    public static int ID = 18;
    private String[] attributes;
    private int attributesLength;
    private int attributesOffset;
    private String text;

    @HeaderLength
    public static int headerLength(JBuffer jBuffer, int n) {
        return jBuffer.size() - n;
    }

    @Field(offset=0, length=10, format="%s[]")
    public String[] attributes() {
        return this.attributes;
    }

    @Dynamic(value=Field.Property.LENGTH)
    public int attributesLength() {
        return this.attributesLength;
    }

    @Dynamic(value=Field.Property.OFFSET)
    public int attributesOffset() {
        return this.attributesOffset;
    }

    protected void decodeHeader() {
        this.text = super.getUTF8String(0, this.size());
        String[] stringArray = this.text.split("\r\n");
        ArrayList<String> arrayList = new ArrayList<String>(10);
        int n = 0;
        for (String string : stringArray) {
            char c = string.charAt(0);
            string = string.substring(2).trim();
            int n2 = string.length() * 8;
            switch (c) {
                case 'v': {
                    super.addField(Fields.Version, string, n, n2);
                    break;
                }
                case 'o': {
                    super.addField(Fields.Owner, string, n, n2);
                    break;
                }
                case 's': {
                    super.addField(Fields.SessionName, string, n, n2);
                    break;
                }
                case 'c': {
                    super.addField(Fields.ConnectionInfo, string, n, n2);
                    break;
                }
                case 't': {
                    super.addField(Fields.Time, string, n, n2);
                    break;
                }
                case 'm': {
                    super.addField(Fields.Media, string, n, n2);
                    break;
                }
                case 'a': {
                    arrayList.add(string);
                }
            }
            n += (string.length() + 2) * 8;
        }
        this.attributesOffset = n;
        this.attributesLength = (this.size() - n / 8) * 8;
        this.attributes = arrayList.toArray(new String[arrayList.size()]);
    }

    public String text() {
        return this.text;
    }

    public int textLength() {
        return this.size() * 8;
    }

    static {
        try {
            ID = JRegistry.register(Sdp.class);
        }
        catch (RegistryHeaderErrors registryHeaderErrors) {
            registryHeaderErrors.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Field
    public static enum Fields {
        ConnectionInfo,
        Media,
        Owner,
        SessionName,
        Time,
        Version;

    }
}

