/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.tcpip.radius;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeRadiusTokenizer
implements Iterable<Token>,
Iterator<Token> {
    private final BufferedReader in;
    private String line;
    private int lineno = 0;
    private final List<Token> tokens = new LinkedList<Token>();

    public FreeRadiusTokenizer(BufferedReader bufferedReader) {
        this.in = bufferedReader;
    }

    public FreeRadiusTokenizer(InputStream inputStream) {
        this(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public Token consume() throws IOException {
        this.consume(1);
        return null;
    }

    public Token consume(int n) throws IOException {
        while (n-- > 0) {
            this.nextToken();
        }
        return null;
    }

    private void fetchTokens() throws IOException {
        String string = this.in.readLine();
        if (string == null) {
            this.tokens.add(new Token(TokenType.EOS, null, -1));
            this.in.close();
            return;
        }
        this.tokenizeLine(string, this.lineno++);
    }

    public Token get() throws IOException {
        return this.nextToken();
    }

    @Override
    public boolean hasNext() {
        try {
            return this.hasNextToken();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public boolean hasNextToken() throws IOException {
        return this.peek().type != TokenType.EOS;
    }

    @Override
    public Iterator<Token> iterator() {
        return this;
    }

    @Override
    public Token next() {
        try {
            return this.nextToken();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public Token nextToken() throws IOException {
        if (this.tokens.isEmpty()) {
            this.fetchTokens();
        }
        Token token = this.tokens.get(0);
        if (token.type != TokenType.EOS) {
            this.tokens.remove(0);
        }
        while (token.type == TokenType.EOL && this.peek((int)0).type == TokenType.EOL) {
            this.tokens.remove(0);
        }
        return token;
    }

    public Token peek() throws IOException {
        return this.peek(0);
    }

    public Token peek(int n) throws IOException {
        if (this.tokens.size() <= n) {
            this.fetchTokens();
        }
        Token token = this.tokens.get(n);
        return token;
    }

    public boolean predicate(int n, TokenType tokenType) throws IOException {
        return this.peek((int)(n + 0)).type == tokenType;
    }

    public boolean predicate(int n, TokenType tokenType, TokenType tokenType2) throws IOException {
        return this.peek((int)(n + 0)).type == tokenType && this.peek((int)(n + 1)).type == tokenType2;
    }

    public boolean predicate(int n, TokenType tokenType, TokenType tokenType2, TokenType tokenType3) throws IOException {
        return this.peek((int)(n + 0)).type == tokenType && this.peek((int)(n + 1)).type == tokenType2 && this.peek((int)(n + 2)).type == tokenType3;
    }

    public boolean predicate(int n, TokenType tokenType, TokenType tokenType2, TokenType tokenType3, TokenType tokenType4) throws IOException {
        return this.peek((int)(n + 0)).type == tokenType && this.peek((int)(n + 1)).type == tokenType2 && this.peek((int)(n + 2)).type == tokenType3 && this.peek((int)(n + 3)).type == tokenType4;
    }

    public boolean predicate(int n, TokenType tokenType, TokenType tokenType2, TokenType tokenType3, TokenType tokenType4, TokenType ... tokenTypeArray) throws IOException {
        boolean bl;
        boolean bl2 = bl = this.peek((int)(n + 0)).type == tokenType && this.peek((int)(n + 1)).type == tokenType2 && this.peek((int)(n + 2)).type == tokenType3 && this.peek((int)(n + 3)).type == tokenType4;
        if (!bl) {
            return false;
        }
        int n2 = n + 4;
        for (TokenType tokenType5 : tokenTypeArray) {
            if (this.peek((int)n2++).type == tokenType5) continue;
            return false;
        }
        return true;
    }

    public Token get(TokenType ... tokenTypeArray) throws IOException {
        Token token = null;
        for (TokenType tokenType : tokenTypeArray) {
            if (token == null && tokenType != null) {
                token = this.get();
                continue;
            }
            this.consume();
        }
        return token;
    }

    public Token get(TokenType tokenType, TokenType tokenType2, TokenType tokenType3, TokenType tokenType4) throws IOException {
        Token token = tokenType == null ? this.consume() : this.get();
        token = token != null || tokenType2 == null ? this.consume() : this.get();
        token = token != null || tokenType3 == null ? this.consume() : this.get();
        token = token != null || tokenType4 == null ? this.consume() : this.get();
        return token;
    }

    public boolean predicate(TokenType tokenType) throws IOException {
        return this.predicate(0, tokenType);
    }

    public boolean predicate(TokenType tokenType, TokenType tokenType2) throws IOException {
        return this.predicate(0, tokenType, tokenType2);
    }

    public boolean predicate(TokenType tokenType, TokenType tokenType2, TokenType tokenType3) throws IOException {
        return this.predicate(0, tokenType, tokenType2, tokenType3);
    }

    public boolean predicate(TokenType tokenType, TokenType tokenType2, TokenType tokenType3, TokenType tokenType4) throws IOException {
        return this.predicate(0, tokenType, tokenType2, tokenType3, tokenType4);
    }

    public boolean predicate(TokenType tokenType, TokenType tokenType2, TokenType tokenType3, TokenType tokenType4, TokenType ... tokenTypeArray) throws IOException {
        return this.predicate(0, tokenType, tokenType2, tokenType3, tokenType4, tokenTypeArray);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void tokenizeLine(String string, int n) {
        String string2;
        String[] stringArray = string.split("[\\s=,]");
        for (int i = 0; i < stringArray.length && !(string2 = stringArray[i].trim()).startsWith("#"); ++i) {
            if (string2.equals("VENDOR")) {
                this.tokens.add(new Token(TokenType.VENDOR, null, n));
                continue;
            }
            if (string2.equals("format")) {
                this.tokens.add(new Token(TokenType.FORMAT, null, n));
                continue;
            }
            if (string2.equals("has_tag")) {
                this.tokens.add(new Token(TokenType.HAS_TAG, null, n));
                continue;
            }
            if (string2.equals("ATTRIBUTE")) {
                this.tokens.add(new Token(TokenType.ATTRIBUTE, null, n));
                continue;
            }
            if (string2.equals("VALUE")) {
                this.tokens.add(new Token(TokenType.VALUE, null, n));
                continue;
            }
            if (string2.equals("$INCLUDE")) {
                this.tokens.add(new Token(TokenType.INCLUDE, null, n));
                continue;
            }
            if (string2.equals("BEGIN-VENDOR")) {
                this.tokens.add(new Token(TokenType.BEGIN_VENDOR, null, n));
                continue;
            }
            if (string2.equals("END-VENDOR")) {
                this.tokens.add(new Token(TokenType.END_VENDOR, null, n));
                continue;
            }
            if (string2.equals("integer")) {
                this.tokens.add(new Token(TokenType.VALUE_TYPE, string2, n));
                continue;
            }
            if (string2.equals("string")) {
                this.tokens.add(new Token(TokenType.VALUE_TYPE, string2, n));
                continue;
            }
            if (string2.equals("ipaddr")) {
                this.tokens.add(new Token(TokenType.VALUE_TYPE, string2, n));
                continue;
            }
            if (string2.equals("ipv6addr")) {
                this.tokens.add(new Token(TokenType.VALUE_TYPE, string2, n));
                continue;
            }
            if (string2.equals("ipv4prefix")) {
                this.tokens.add(new Token(TokenType.VALUE_TYPE, string2, n));
                continue;
            }
            if (string2.equals("ifid")) {
                this.tokens.add(new Token(TokenType.VALUE_TYPE, string2, n));
                continue;
            }
            if (string2.equals("octets")) {
                this.tokens.add(new Token(TokenType.VALUE_TYPE, string2, n));
                continue;
            }
            if (string2.equals("abinary")) {
                this.tokens.add(new Token(TokenType.VALUE_TYPE, string2, n));
                continue;
            }
            if (string2.equals("ether")) {
                this.tokens.add(new Token(TokenType.VALUE_TYPE, string2, n));
                continue;
            }
            if (Pattern.matches("^0x[0123456789abcdef]+", string2)) {
                this.tokens.add(new Token(TokenType.NUMBER, this.hex2dec(string2), n));
                continue;
            }
            if (Pattern.matches("^\\d+", string2)) {
                this.tokens.add(new Token(TokenType.NUMBER, string2, n));
                continue;
            }
            if (!Pattern.matches("^[\\w\\.-]+", string2)) continue;
            this.tokens.add(new Token(TokenType.ID, string2, n));
        }
        this.tokens.add(new Token(TokenType.EOL, null, n));
    }

    private String hex2dec(String string) {
        string = string.replaceFirst("0x", "");
        long l = Long.parseLong(string, 16);
        return Long.toString(l);
    }

    private long parseLong(String string, int n) {
        string = string.replaceFirst("0x", "");
        long l = Long.parseLong(string, 16);
        return l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TokenType {
        ASSIGNMENT,
        ATTRIBUTE,
        BEGIN_VENDOR,
        COMMA,
        ECRYPT,
        END_VENDOR,
        EOL,
        EOS,
        FORMAT,
        HAS_TAG,
        ID,
        INCLUDE,
        NUMBER,
        VALUE,
        VALUE_TYPE,
        VENDOR;

    }

    public static class Token {
        private final int lineno;
        public final TokenType type;
        public final String value;

        public Token(TokenType tokenType, String string, int n) {
            this.type = tokenType;
            this.value = string;
            this.lineno = n;
        }

        public String toString() {
            if (this.value != null) {
                return this.type.name() + "(" + this.value + ")";
            }
            return this.type.name();
        }

        public String stringValue() {
            return this.value;
        }

        public int intValue() {
            return Integer.parseInt(this.value);
        }

        public long longValue() {
            return Long.parseLong(this.value);
        }

        public double doubleValue() {
            return Double.parseDouble(this.value);
        }

        public float FloatValue() {
            return Float.parseFloat(this.value);
        }
    }
}

