/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import com.slytechs.library.JNILibrary;
import com.slytechs.library.Library;
import com.slytechs.library.LibraryInitializer;
import java.nio.ByteBuffer;
import org.jnetpcap.JCaptureHeader;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapPktHdr;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JPacket;

@Library(preload={Pcap.class}, jni={"jnetpcap"})
public class PcapDumper {
    private volatile long physical;

    @LibraryInitializer
    private static native void initIDs();

    public native void close();

    public void dump(JPacket jPacket) {
        this.dump(jPacket.getCaptureHeader(), jPacket);
    }

    public void dump(long l, int n, int n2, byte[] byArray) {
        this.dump(l, n, n2, byArray, 0, byArray.length);
    }

    public void dump(long l, int n, int n2, byte[] byArray, int n3, int n4) {
        this.dump0(l, n, n2, byArray, n3, n4);
    }

    private native void dump0(long var1, int var3, int var4, byte[] var5, int var6, int var7);

    public void dump(long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            this.dump(l, n, n3, byArray, byteBuffer.arrayOffset(), byteBuffer.capacity());
        } else {
            this.dump1(l, n, n2, byteBuffer, 0, byteBuffer.capacity());
        }
    }

    private native void dump1(long var1, int var3, int var4, ByteBuffer var5, int var6, int var7);

    public void dump(long l, int n, int n2, ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset();
            this.dump(l, n, n2, byArray, n3 + byteBuffer.position(), n3 + byteBuffer.limit());
        } else {
            this.dump1(l, n, n2, byteBuffer, byteBuffer.position(), byteBuffer.limit());
        }
    }

    public void dump(long l, int n, int n2, JBuffer jBuffer) {
        this.dump2(l, n, n2, jBuffer, 0, jBuffer.size());
    }

    public void dump(long l, int n, int n2, JBuffer jBuffer, int n3, int n4) {
        this.dump2(l, n, n2, jBuffer, n3, n4);
    }

    private native void dump2(long var1, int var3, int var4, JBuffer var5, int var6, int var7);

    public void dump(JCaptureHeader jCaptureHeader, ByteBuffer byteBuffer) {
        this.dump(jCaptureHeader.seconds(), (int)jCaptureHeader.nanos() / 1000, jCaptureHeader.wirelen(), byteBuffer);
    }

    public void dump(JCaptureHeader jCaptureHeader, JBuffer jBuffer) {
        this.dump(jCaptureHeader.seconds(), (int)jCaptureHeader.nanos() / 1000, jCaptureHeader.wirelen(), jBuffer);
    }

    @Deprecated
    public void dump(PcapPktHdr pcapPktHdr, ByteBuffer byteBuffer) {
        this.dump(pcapPktHdr.getSeconds(), pcapPktHdr.getUseconds(), pcapPktHdr.getCaplen(), pcapPktHdr.getLen(), byteBuffer);
    }

    public native int flush();

    public native long ftell();

    static {
        JNILibrary.register(PcapDumper.class);
    }
}

