package de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;

import com.google.inject.Inject;

import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.HtmlProvider;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.ConfigProvider;

/**
 * 
 * @author Norbert Bissmeyer (norbert.bissmeyer@sit.fraunhofer.de)
 * 
 */
public class FileDownload extends AbstractServlet {

	private static final long serialVersionUID = 1L;

	@InjectLogger
	private Logger logger;
	public static final String URL = "/packageDownload";
	public static final String TITLE = "PKI Package Download";
	private static final int BUFSIZE = 4096;

	@Inject
	private ConfigProvider configProvider;

	@Inject
	public FileDownload(HtmlProvider htmlProvider) {
		super(htmlProvider);
	}

	@Override
	public String getUrl() {
		return URL;
	}

	@Override
	public String getTitle() {
		return TITLE;
	}
	
	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		String filePath = configProvider.get("webPagePkiPackageSoftwareFilePath");
		if (filePath.isEmpty()) {
			logger.error("No file found at location " + filePath);
			OutputStream out = resp.getOutputStream();

			HttpSession session = req.getSession();

			/* Get Content-Type. */
			String contentType = "application/xhtml+xml";

			/* Set headers. */
			resp.setHeader("Content-Type", contentType);
			// response.setHeader("Cache-Control", "max-age=604800");
			resp.setCharacterEncoding("UTF-8");

			/* Send response header with Content-Length. */
			resp.setStatus(404);

			out.write(htmlProvider.provide(session, getTitle(),
					contentHtml(req, resp)).getBytes());

			out.flush();
			out.close();
		} else {
			File file = new File(filePath);
	        int length   = 0;
	        ServletOutputStream outStream = resp.getOutputStream();
	        ServletContext context  = getServletConfig().getServletContext();
	        String mimetype = context.getMimeType(filePath);
	        
	        // sets response content type
	        if (mimetype == null) {
	            mimetype = "application/octet-stream";
	        }
	        resp.setContentType(mimetype);
	        resp.setContentLength((int)file.length());
	        String fileName = (new File(filePath)).getName();
	        
	        // sets HTTP header
	        resp.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
	        
	        byte[] byteBuffer = new byte[BUFSIZE];
	        DataInputStream in = new DataInputStream(new FileInputStream(file));
	        
	        // reads the file's bytes and writes them to the response stream
	        while ((in != null) && ((length = in.read(byteBuffer)) != -1))
	        {
	            outStream.write(byteBuffer,0,length);
	        }
	        
	        in.close();
	        outStream.close();
		}
	}

	@Override
	public boolean isProtected() {
		return true;
	}

	@Override
	public String[] getAllowedRoles() {
		return new String[] { UserRole.ADMINISTRATOR.toString(), UserRole.REGISTRATION_USER.toString(),
				UserRole.DEVELOPER.toString() };
	}

	@Override
	public Category getCategory() {
		return Category.PKI_PACKAGE;
	}

	@Override
	protected String contentHtml(HttpServletRequest req, HttpServletResponse resp) {
		return "";
	}
}
