package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.validator.time;

import de.fraunhofer.sit.c2x.pki.ca.validator.Validator;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Time32;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.ValidityRestriction;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class ExpirationTimeValidator implements Validator<ValidityRestriction[]> {

	@Override
	public boolean validate(ValidityRestriction[] object) {
		boolean result = false;
		Time32[] time;
		try {
			time = TimeUtils.extractTime(object);
			
			// check that end time is not in the past
			result = !time[1].isPastDate();
			
			// check that end time is not before start time
			if (result == true)
				result = !time[1].before(time[0]);
			
			return result;
		} catch (IllegalArgumentException e) {
			return false;
		}

	}
}
