package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class HeadingWithConfidence extends WaveElement {

	// ---- fields ----

	@Internal(order = 0)
	private UInt16 heading;

	@Internal(order = 1)
	private UInt8 confidence;

	// ---- fields ----

	// ---- constructors ----

	public HeadingWithConfidence() {
	}

	public HeadingWithConfidence(DataInputStream in) {
	}

	// ---- accept ----

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	// ---- getter ----

	public UInt16 getHeading() {
		return this.heading;
	}

	public UInt8 getConfidence() {
		return this.confidence;
	}

	// ---- setter ----

	public void setHeading(UInt16 heading) {
		this.heading = heading;
	}

	public void setConfidence(UInt8 confidence) {
		this.confidence = confidence;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		if (heading == null || confidence == null)
			throw new IllegalArgumentException();
		int written = heading.writeData(out);
		written += confidence.writeData(out);
		return written;
	}
}