package de.fraunhofer.sit.c2x.pki;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;

import de.fraunhofer.sit.c2x.pki.ca.certificates.CertificateBuilder;
import de.fraunhofer.sit.c2x.pki.ca.core.logging.Log4JTypeListener;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.GeorgraphicRegionValidator;

public class CertificateBuilderModule extends AbstractModule {

	public static enum VersionEnum {
		ETSI_TS_103_097_v111, ETSI_TS_103_097_v117, ETSI_TS_103_097_v1114, IEEE_1609_2_v2_D9
	}

	@Override
	protected void configure() {

		VersionEnum version = VersionEnum.ETSI_TS_103_097_v1114;

		// Switch between IEEE Version and Etsi Version!
		switch (version) {
		case ETSI_TS_103_097_v111:
//			bind(CertificateBuilder.class).to(
//					de.fraunhofer.sit.c2x.pki.etsi_ts103097v111.utils.EtsiCertificateBuilder.class).in(
//					Singleton.class);
			break;
		case ETSI_TS_103_097_v117:
//			bind(CertificateBuilder.class).to(
//					de.fraunhofer.sit.c2x.pki.etsi_ts103097v117.utils.EtsiCertificateBuilder.class).in(
//					Singleton.class);
			break;
		case ETSI_TS_103_097_v1114:
			bind(CertificateBuilder.class).to(
					de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.EtsiCertificateBuilderInvalidContent.class).in(
					Singleton.class);
			break;
		case IEEE_1609_2_v2_D9:
//			bind(CertificateBuilder.class).to(
//					de.fraunhofer.sit.c2x.pki.ieee1609_2_d9.utils.IEEECertificateBuilder.class).in(
//					Singleton.class);
			break;
		default:
			break;
		}

		bindListener(Matchers.any(), new Log4JTypeListener());
		bind(CertificateGenerator.class);
		bind(CertChainGenerator.class);
		bind(GeorgraphicRegionValidator.class);
	}

}
