package org.etsi.ttcn.codec.its.adapter;

import org.etsi.ttcn.codec.CodecBuffer;
import org.etsi.ttcn.codec.MainCodec;
import org.etsi.ttcn.codec.generic.Union;
import org.etsi.common.ByteHelper;
import org.etsi.ttcn.tci.Type;
import org.etsi.ttcn.tci.UnionValue;

public class AcSecPrimitive extends Union {

    public AcSecPrimitive(MainCodec mainCodec) {
        super(mainCodec);
    }

    @Override
    protected void preDecode(CodecBuffer buf, Type decodingHypothesis) {

        // Read message id (AcSecPrimitive)
        if(0x00 != (0x00FF & buf.readBytes(1)[0])) {
            return;
        }

        // Read primitive id
        int primitiveId = 0x00FF & buf.readBytes(1)[0];
        String primitive = "";

        switch(primitiveId) {
        case 0x7a:
            primitive = "acEnableSecurity";
            break;
        case 0x7b:
            primitive = "acDisableSecurity";
            break;
        }

        mainCodec.setHint(decodingHypothesis.getName(), primitive);
    }

    @Override
    protected void preEncode(CodecBuffer buf, UnionValue uv) {
        String variant = uv.getPresentVariantName();
        int primitiveId = -1;
        
        // Append AcSecPrimitive message id
        buf.appendBytes(ByteHelper.intToByteArray(3, 1));

        // Append primitive id
        if(variant.equals("acEnableSecurity")) {
            primitiveId = 0x7a;
            mainCodec.setHint("ScenarioLen", "16");
        }
        else if(variant.equals("acDisableSecurity")) {
            primitiveId = 0x7b;
        }
        buf.appendBytes(ByteHelper.intToByteArray(primitiveId, 1));
    }
}
