/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.sigtran;

import java.nio.ByteOrder;
import java.util.ArrayList;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.format.FormatUtils;
import org.jnetpcap.protocol.sigtran.SctpChunk;

public abstract class SctpInitBaseclass
extends SctpChunk {
    static TLV[] readTLVS(JBuffer jBuffer, int n) {
        int n2;
        ArrayList<TLV> arrayList = new ArrayList<TLV>();
        for (int i = 20; i < n; i += n2) {
            TLV tLV = TLV.create(jBuffer, i);
            arrayList.add(tLV);
            n2 = jBuffer.getUShort(i + 2);
            n2 += 4 - n2 % 4 & 3;
        }
        return arrayList.toArray(new TLV[arrayList.size()]);
    }

    public void istream(int n) {
        super.setUShort(14, n);
    }

    @Field(offset=112, length=16, display="Inbound Streams")
    public int istreams() {
        return super.getUShort(14);
    }

    public void ostream(int n) {
        super.setUShort(12, n);
    }

    @Field(offset=96, length=16, display="Outbound Streams")
    public int ostreams() {
        return super.getUShort(12);
    }

    @Field(offset=160, length=0, display="TLV Parameter", format="%s[]")
    public String[] printTlvs() {
        TLV[] tLVArray = this.tlvs();
        String[] stringArray = new String[tLVArray.length];
        for (int i = 0; i < tLVArray.length; ++i) {
            stringArray[i] = tLVArray[i].toString();
        }
        return stringArray;
    }

    @Field(offset=32, length=32, display="Initiate Tag")
    public long tag() {
        return super.getUInt(4);
    }

    public void tag(long l) {
        super.setUInt(4, l);
    }

    public TLV[] tlvs() {
        return SctpInitBaseclass.readTLVS(this, this.length());
    }

    @Field(offset=128, length=32, display="Initial TSN", format="%lx")
    public long tsn() {
        return super.getUInt(16);
    }

    public void tsn(long l) {
        super.setUInt(16, l);
    }

    @Field(offset=64, length=32, display="Advertised Receiver Window Credit")
    public long window() {
        return super.getUInt(8);
    }

    public void window(long l) {
        super.setUInt(8, l);
    }

    public static class UnrecognizedParametersTLV
    extends TLV {
        private final int length;

        public UnrecognizedParametersTLV(JBuffer jBuffer, int n, int n2) {
            super(jBuffer, n, n2);
            this.length = n2;
        }

        public int count() {
            int n = 0;
            int n2 = 4;
            while (n2 < this.length) {
                int n3 = super.getUShort(n2 + 2);
                n2 += n3;
                ++n;
            }
            return n;
        }

        public TLV[] parameters() {
            return this.parameters(new TLV[this.count()]);
        }

        public TLV[] parameters(TLV[] tLVArray) {
            int n = 4;
            for (int i = 0; i < tLVArray.length; ++i) {
                int n2 = super.getUShort(n);
                int n3 = super.getUShort(n + 2);
                int n4 = n3 + (4 - n3 % 4 & 3);
                tLVArray[i] = new TLV(String.format("#%d[type=%X, len=%d]", n2, n4), this, n, n3);
                n += n4;
            }
            return tLVArray;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Supported Address Types: ");
            for (TLV tLV : this.parameters()) {
                if (stringBuilder.length() != "Supported Address Types: ".length()) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(tLV);
            }
            return stringBuilder.toString();
        }
    }

    public static class TLV
    extends JBuffer {
        public static final int IPV4_TLV = 5;
        public static final int IPV6_TLV = 6;
        public static final int STATE_COOKIE_TLV = 7;
        public static final int UNRECOGNIZED_PARAMETER_TLV = 8;
        public static final int COOKIE_LIFESPAN_TLV = 9;
        public static final int HOSTNAME_TLV = 11;
        public static final int ADDRESS_TYPES_TLV = 12;
        public static final int ECN_TLV = 32768;
        public static final int FORWARD_TSN_TLV = 49152;
        public static final int ADAPTATION_LAYER_TLV = 49158;
        private final String label;

        public static TLV create(JBuffer jBuffer, int n) {
            int n2 = jBuffer.getUShort(n);
            int n3 = jBuffer.getUShort(n + 2);
            switch (n2) {
                case 5: {
                    return new Ip4TLV(jBuffer, n, n3);
                }
                case 6: {
                    return new Ip6TLV(jBuffer, n, n3);
                }
                case 7: {
                    return new StateCookieTLV(jBuffer, n, n3);
                }
                case 8: {
                    return new UnrecognizedParametersTLV(jBuffer, n, n3);
                }
                case 9: {
                    return new CookieTLV(jBuffer, n, n3);
                }
                case 11: {
                    return new HostnameTLV(jBuffer, n, n3);
                }
                case 12: {
                    return new AddressTypeTLV(jBuffer, n, n3);
                }
                case 32768: {
                    return new TLV("ECN", jBuffer, n, n3);
                }
                case 49152: {
                    return new TLV("Forward TSN Supported", jBuffer, n, n3);
                }
                case 49158: {
                    long l = jBuffer.getUInt(n + 4);
                    return new TLV(String.format("Adaptation Layer Indication: 0x%08X", l), jBuffer, n, n3);
                }
            }
            return new TLV(String.format("Unrecognized type=%04X, length=%d", n2, n3), jBuffer, n, n3);
        }

        public TLV(JBuffer jBuffer, int n, int n2) {
            super(JMemory.Type.POINTER);
            this.peer(jBuffer, n, n2);
            this.order(ByteOrder.BIG_ENDIAN);
            this.label = "";
        }

        public TLV(String string, JBuffer jBuffer, int n, int n2) {
            super(JMemory.Type.POINTER);
            this.label = string;
            this.peer(jBuffer, n, n2);
            this.order(ByteOrder.BIG_ENDIAN);
        }

        public int length() {
            return super.getUShort(2);
        }

        public void length(int n) {
            super.setUShort(2, n);
        }

        public String toString() {
            return this.label;
        }

        public int type() {
            return super.getUShort(0);
        }

        public void type(int n) {
            super.setUShort(0, n);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TLVTypes {
            IPV4,
            IPV6,
            COOKIE_LIFESPAN,
            HOSTNAME,
            ADDRESS_TYPES;

        }
    }

    public static class StateCookieTLV
    extends TLV {
        public StateCookieTLV(JBuffer jBuffer, int n, int n2) {
            super(jBuffer, n, n2);
        }

        public byte[] cookie() {
            return this.cookie(new byte[this.cookieLength()]);
        }

        public byte[] cookie(byte[] byArray) {
            return super.getByteArray(4, byArray);
        }

        public int cookieLength() {
            return this.length() - 4;
        }

        public String toString() {
            byte[] byArray = this.cookie(new byte[16]);
            return String.format("Cookie: %s", FormatUtils.hexLineData(byArray, 0));
        }
    }

    public static class Ip6TLV
    extends TLV {
        public Ip6TLV(JBuffer jBuffer, int n, int n2) {
            super(jBuffer, n, n2);
        }

        public byte[] address() {
            return this.address(new byte[16]);
        }

        public byte[] address(byte[] byArray) {
            if (byArray.length != 16) {
                throw new IllegalArgumentException("need 16 byte array for Ip6 address");
            }
            super.getByteArray(4, byArray);
            return byArray;
        }

        public void setAddress(byte[] byArray) {
            if (byArray.length != 16) {
                throw new IllegalArgumentException("need 16 byte array for Ip6 address");
            }
            super.setByteArray(4, byArray);
        }

        public String toString() {
            return String.format("Ip4 Address: %s", FormatUtils.ip(this.address()));
        }
    }

    public static class Ip4TLV
    extends TLV {
        public Ip4TLV(JBuffer jBuffer, int n, int n2) {
            super(jBuffer, n, n2);
        }

        public byte[] address() {
            return this.address(new byte[4]);
        }

        public byte[] address(byte[] byArray) {
            if (byArray.length != 4) {
                throw new IllegalArgumentException("need 4 byte array for Ip4 address");
            }
            super.getByteArray(4, byArray);
            return byArray;
        }

        public void setAddress(byte[] byArray) {
            if (byArray.length != 4) {
                throw new IllegalArgumentException("need 4 byte array for Ip4 address");
            }
            super.setByteArray(4, byArray);
        }

        public String toString() {
            return String.format("Ip4 Address: %s", FormatUtils.ip(this.address()));
        }
    }

    public static class HostnameTLV
    extends TLV {
        public HostnameTLV(JBuffer jBuffer, int n, int n2) {
            super(jBuffer, n, n2);
        }

        public String hostname() {
            return super.getUTF8String(4, this.length() - 4);
        }

        public String toString() {
            return String.format("hostname: %s", this.hostname());
        }
    }

    public static class CookieTLV
    extends TLV {
        public CookieTLV(JBuffer jBuffer, int n, int n2) {
            super(jBuffer, n, n2);
        }

        public long lifeSpan() {
            return super.getUInt(4);
        }

        public void lifeSpan(long l) {
            super.setUInt(4, l);
        }

        public String toString() {
            return String.format("Cookie Life-Span: %d ms", this.lifeSpan());
        }
    }

    public static class AddressTypeTLV
    extends TLV {
        public AddressTypeTLV(JBuffer jBuffer, int n, int n2) {
            super(jBuffer, n, n2);
        }

        public int[] addressTypes() {
            return this.addressTypes(new int[this.count()]);
        }

        public int[] addressTypes(int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = super.getUShort(4 + i * 2);
            }
            return nArray;
        }

        public int count() {
            int n = super.length();
            return (n - 4) / 2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Supported Address Types: ");
            for (int n : this.addressTypes()) {
                if (stringBuilder.length() != "Supported Address Types: ".length()) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(n);
            }
            return stringBuilder.toString();
        }
    }
}

