/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.structure;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.FieldDefinitionException;
import org.jnetpcap.packet.structure.AnnotatedField;
import org.jnetpcap.packet.structure.AnnotatedMethod;
import org.jnetpcap.packet.structure.AnnotatedMethodException;
import org.jnetpcap.packet.structure.HeaderDefinitionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotatedFieldMethod
extends AnnotatedMethod {
    protected final String field;
    protected final Field.Property function;

    public static void checkAnnotation(Method method, List<AnnotatedField> list) {
        Dynamic dynamic = method.getAnnotation(Dynamic.class);
        if (dynamic.field().length() != 0) {
            boolean bl = false;
            String string = dynamic.field();
            for (AnnotatedField annotatedField : list) {
                if (!annotatedField.getName().equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new HeaderDefinitionError("field name defined in annotation ");
            }
        }
    }

    private static void checkSignature(Method method, Class<?> clazz) {
        Class<?> clazz2 = method.getDeclaringClass();
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 1 && classArray[0] != String.class || classArray.length > 1 || method.getReturnType() != clazz) {
            throw new AnnotatedMethodException(clazz2, "Invalid signature for " + method.getName() + "()");
        }
        if ((method.getModifiers() & 8) != 0) {
            throw new AnnotatedMethodException(clazz2, method.getName() + "()" + " can not be declared static");
        }
    }

    public static AnnotatedFieldMethod generateFunction(Field.Property property, AnnotatedField annotatedField) {
        switch (property) {
            case LENGTH: 
            case OFFSET: {
                return new IntFunction(annotatedField, property);
            }
            case MASK: {
                return new LongFunction(annotatedField, property);
            }
            case VALUE: {
                return new ObjectFunction(annotatedField, property);
            }
            case CHECK: {
                return new BooleanFunction(annotatedField, property);
            }
            case UNITS: 
            case DISPLAY: 
            case DESCRIPTION: {
                return new StringFunction(annotatedField, property);
            }
        }
        throw new HeaderDefinitionError("Unsupported Dynamic function type " + property.toString());
    }

    private static String guessFieldName(String string) {
        if (string.startsWith("has")) {
            String string2 = string.replace("has", "");
            char c = string2.charAt(0);
            char c2 = Character.toLowerCase(c);
            return string2.replace(c, c2);
        }
        if (string.endsWith("Description")) {
            return string.replace("Description", "");
        }
        if (string.endsWith("Offset")) {
            return string.replace("Offset", "");
        }
        if (string.endsWith("Length")) {
            return string.replace("Length", "");
        }
        if (string.endsWith("Mask")) {
            return string.replace("Mask", "");
        }
        if (string.endsWith("Value")) {
            return string.replace("Value", "");
        }
        if (string.endsWith("Display")) {
            return string.replace("Display", "");
        }
        if (string.endsWith("Units")) {
            return string.replace("Units", "");
        }
        if (string.endsWith("Format")) {
            return string.replace("Format", "");
        }
        return string;
    }

    public static AnnotatedFieldMethod inspectMethod(Method method) {
        Dynamic dynamic = method.getAnnotation(Dynamic.class);
        Field.Property property = dynamic.value();
        switch (property) {
            case LENGTH: 
            case OFFSET: {
                AnnotatedFieldMethod.checkSignature(method, Integer.TYPE);
                return new IntFunction(method, property);
            }
            case MASK: {
                AnnotatedFieldMethod.checkSignature(method, Long.TYPE);
                return new LongFunction(method, property);
            }
            case VALUE: {
                AnnotatedFieldMethod.checkSignature(method, Object.class);
                return new ObjectFunction(method, property);
            }
            case CHECK: {
                AnnotatedFieldMethod.checkSignature(method, Boolean.TYPE);
                return new BooleanFunction(method, property);
            }
            case DISPLAY: 
            case DESCRIPTION: {
                AnnotatedFieldMethod.checkSignature(method, String.class);
                return new StringFunction(method, property);
            }
        }
        throw new HeaderDefinitionError("Unsupported Dynamic function type " + property.toString());
    }

    public AnnotatedFieldMethod(AnnotatedField annotatedField, Field.Property property) {
        this.function = property;
        this.field = annotatedField.getName();
    }

    public AnnotatedFieldMethod(AnnotatedField annotatedField, Field.Property property, Method method) {
        super(method);
        this.function = property;
        this.field = annotatedField.getName();
    }

    public AnnotatedFieldMethod(Method method, Field.Property property) {
        super(method);
        this.function = property;
        Dynamic dynamic = method.getAnnotation(Dynamic.class);
        if (dynamic == null) {
            throw new HeaderDefinitionError(method.getDeclaringClass(), "unable get field's annotated runtime");
        }
        this.field = dynamic.field().length() != 0 ? dynamic.field() : AnnotatedFieldMethod.guessFieldName(method.getName());
    }

    public boolean booleanMethod(JHeader jHeader, String string) {
        throw new UnsupportedOperationException("this return type is invalid for this function type");
    }

    public abstract void configFromField(AnnotatedField var1);

    public String getFieldName() {
        return this.field;
    }

    public final Field.Property getFunction() {
        return this.function;
    }

    public int intMethod(JHeader jHeader, String string) {
        throw new UnsupportedOperationException("this return type is invalid for this function type");
    }

    public Object objectMethod(JHeader jHeader, String string) {
        throw new UnsupportedOperationException("this return type is invalid for this function type");
    }

    public String stringMethod(JHeader jHeader, String string) {
        throw new UnsupportedOperationException("this return type is invalid for this function type");
    }

    @Override
    protected void validateSignature(Method method) {
    }

    public long longMethod(JHeader jHeader, String string) {
        throw new UnsupportedOperationException("this return type is invalid for this function type");
    }

    private static class StringFunction
    extends AnnotatedFieldMethod {
        private boolean hasStaticValue = false;
        private String value;

        public StringFunction(AnnotatedField annotatedField, Field.Property property) {
            super(annotatedField, property);
            annotatedField.getMethod().setAccessible(true);
            this.configFromField(annotatedField);
        }

        public StringFunction(Method method, Field.Property property) {
            super(method, property);
            method.setAccessible(true);
        }

        public final void configFromField(AnnotatedField annotatedField) {
            switch (this.function) {
                case UNITS: {
                    if (annotatedField.getUnits().length() != 0) {
                        this.setValue(annotatedField.getUnits());
                        break;
                    }
                    if (this.method != null) break;
                    this.setValue(null);
                    break;
                }
                case DISPLAY: {
                    if (annotatedField.getDisplay().length() != 0) {
                        this.setValue(annotatedField.getDisplay());
                        break;
                    }
                    if (this.method != null) break;
                    this.setValue(null);
                    break;
                }
                case DESCRIPTION: {
                    if (annotatedField.getDescription().length() != 0) {
                        this.setValue(annotatedField.getDescription());
                        break;
                    }
                    if (this.method != null) break;
                    this.setValue(null);
                    break;
                }
                default: {
                    throw new HeaderDefinitionError("Invalid Dynamic function type " + this.function.toString());
                }
            }
            if (!this.hasStaticValue && this.method == null) {
                throw new FieldDefinitionException(annotatedField, "Missing '" + this.function.name().toLowerCase() + "' property. [@Field(" + this.function.name().toLowerCase() + "=<string>) or @Dynamic(Property." + this.function.name() + ")]");
            }
        }

        public String execute(JHeader jHeader, String string) {
            if (this.hasStaticValue) {
                return this.value;
            }
            try {
                if (this.isMapped) {
                    return (String)this.method.invoke((Object)jHeader, string);
                }
                return (String)this.method.invoke((Object)jHeader, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AnnotatedMethodException(this.declaringClass, (Throwable)invocationTargetException);
            }
        }

        private void setValue(String string) {
            this.hasStaticValue = true;
            this.value = string;
        }

        public String stringMethod(JHeader jHeader, String string) {
            return this.execute(jHeader, string);
        }
    }

    private static class ObjectFunction
    extends AnnotatedFieldMethod {
        public ObjectFunction(AnnotatedField annotatedField, Field.Property property) {
            super(annotatedField, property, annotatedField.getMethod());
            annotatedField.getMethod().setAccessible(true);
        }

        public ObjectFunction(Method method, Field.Property property) {
            super(method, property);
            method.setAccessible(true);
        }

        public final void configFromField(AnnotatedField annotatedField) {
            switch (this.function) {
                case VALUE: {
                    if (this.method != null) break;
                    throw new HeaderDefinitionError(annotatedField.getDeclaringClass(), "no method set for field value getter [" + annotatedField.getName() + "]");
                }
                default: {
                    throw new HeaderDefinitionError(annotatedField.getDeclaringClass(), "Invalid Dynamic function type " + this.function.toString());
                }
            }
            if (this.method == null) {
                throw new FieldDefinitionException(annotatedField, "Missing field accessor '" + this.function.name().toLowerCase() + "' property. [@Dynamic(Property." + this.function.name() + ")]");
            }
        }

        public Object execute(JHeader jHeader, String string) {
            try {
                if (this.isMapped) {
                    return this.method.invoke((Object)jHeader, string);
                }
                return this.method.invoke((Object)jHeader, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AnnotatedMethodException(this.declaringClass, invocationTargetException.getMessage(), invocationTargetException);
            }
        }

        public Object objectMethod(JHeader jHeader, String string) {
            return this.execute(jHeader, string);
        }
    }

    private static class LongFunction
    extends AnnotatedFieldMethod {
        private boolean hasStaticValue = false;
        private long value;

        public LongFunction(AnnotatedField annotatedField, Field.Property property) {
            super(annotatedField, property);
            this.configFromField(annotatedField);
            annotatedField.getMethod().setAccessible(true);
        }

        public LongFunction(AnnotatedField annotatedField, Field.Property property, long l) {
            super(annotatedField, property);
            this.setValue(l);
            annotatedField.getMethod().setAccessible(true);
        }

        public LongFunction(Method method, Field.Property property) {
            super(method, property);
            method.setAccessible(true);
        }

        public final void configFromField(AnnotatedField annotatedField) {
            switch (this.function) {
                case MASK: {
                    this.setValue(annotatedField.getMask());
                    break;
                }
                default: {
                    throw new HeaderDefinitionError("Invalid Dynamic function type " + this.function.toString());
                }
            }
            if (!this.hasStaticValue && this.method == null) {
                throw new FieldDefinitionException(annotatedField, "Missing '" + this.function.name().toLowerCase() + "' property. [@Field(" + this.function.name().toLowerCase() + "=<int>) or @Dynamic(Property." + this.function.name() + ")]");
            }
        }

        public long execute(JHeader jHeader, String string) {
            if (this.hasStaticValue) {
                return this.value;
            }
            try {
                if (this.isMapped) {
                    return (Long)this.method.invoke((Object)jHeader, string);
                }
                return (Long)this.method.invoke((Object)jHeader, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AnnotatedMethodException(this.declaringClass, (Throwable)invocationTargetException);
            }
        }

        public long longMethod(JHeader jHeader, String string) {
            return this.execute(jHeader, string);
        }

        private void setValue(long l) {
            this.hasStaticValue = true;
            this.value = l;
        }
    }

    private static class IntFunction
    extends AnnotatedFieldMethod {
        private boolean hasStaticValue = false;
        private int value;

        public IntFunction(AnnotatedField annotatedField, Field.Property property) {
            super(annotatedField, property);
            this.configFromField(annotatedField);
            annotatedField.getMethod().setAccessible(true);
        }

        public IntFunction(AnnotatedField annotatedField, Field.Property property, int n) {
            super(annotatedField, property);
            this.setValue(n);
            annotatedField.getMethod().setAccessible(true);
        }

        public IntFunction(Method method, Field.Property property) {
            super(method, property);
            method.setAccessible(true);
        }

        public final void configFromField(AnnotatedField annotatedField) {
            switch (this.function) {
                case LENGTH: {
                    if (annotatedField.getLength() == -1) break;
                    this.setValue(annotatedField.getLength());
                    break;
                }
                case OFFSET: {
                    if (annotatedField.getOffset() == -1) break;
                    this.setValue(annotatedField.getOffset());
                    break;
                }
                default: {
                    throw new HeaderDefinitionError("Invalid Dynamic function type " + this.function.toString());
                }
            }
            if (!this.hasStaticValue && this.method == null) {
                throw new FieldDefinitionException(annotatedField, "Missing '" + this.function.name().toLowerCase() + "' property. [@Field(" + this.function.name().toLowerCase() + "=<int>) or @Dynamic(Property." + this.function.name() + ")]");
            }
        }

        public int execute(JHeader jHeader, String string) {
            if (this.hasStaticValue) {
                return this.value;
            }
            try {
                if (this.isMapped) {
                    return (Integer)this.method.invoke((Object)jHeader, string);
                }
                return (Integer)this.method.invoke((Object)jHeader, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AnnotatedMethodException(this.declaringClass, (Throwable)invocationTargetException);
            }
        }

        public int intMethod(JHeader jHeader, String string) {
            return this.execute(jHeader, string);
        }

        private void setValue(int n) {
            this.hasStaticValue = true;
            this.value = n;
        }
    }

    private static class BooleanFunction
    extends AnnotatedFieldMethod {
        private boolean hasStaticValue = false;
        private boolean value;

        public BooleanFunction(AnnotatedField annotatedField, Field.Property property) {
            super(annotatedField, property);
            this.setValue(true);
            annotatedField.getMethod().setAccessible(true);
        }

        public BooleanFunction(Method method, Field.Property property) {
            super(method, property);
            method.setAccessible(true);
        }

        public boolean booleanMethod(JHeader jHeader, String string) {
            return this.execute(jHeader, string);
        }

        public final void configFromField(AnnotatedField annotatedField) {
            switch (this.function) {
                case CHECK: {
                    break;
                }
                default: {
                    throw new HeaderDefinitionError("Invalid Dynamic function type " + this.function.toString());
                }
            }
            if (!this.hasStaticValue && this.method == null) {
                throw new FieldDefinitionException(annotatedField, "Missing '" + this.function.name().toLowerCase() + "' property. [@Dynamic(Property." + this.function.name() + ")]");
            }
        }

        public boolean execute(JHeader jHeader, String string) {
            if (this.hasStaticValue) {
                return this.value;
            }
            try {
                if (this.isMapped) {
                    return (Boolean)this.method.invoke((Object)jHeader, string);
                }
                return (Boolean)this.method.invoke((Object)jHeader, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AnnotatedMethodException(this.declaringClass, (Throwable)invocationTargetException);
            }
        }

        private void setValue(boolean bl) {
            this.hasStaticValue = true;
            this.value = bl;
        }
    }
}

