package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.ca.utils.ByteUtils;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * Representation of Unit16 type: an unsigned, 16-bit integer.
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class UInt16 extends UInt8 {

	public UInt16(int val) {
		set(val);
	}

	public UInt16(DataInputStream in) throws IOException {
		super(in);
	}

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit((UInt16) this);
	}

	protected void set(DataInputStream in) throws IOException {
		byte[] tmp = new byte[2];
		in.readFully(tmp);
		this.data = ByteUtils.convert2ByteArrayToInt(tmp) & 0x0000FFFF;
	}

	public void set(int data) {
		if (data < 0 || data > 65535) {
			throw new IllegalArgumentException(
					"Wrong input! Value shall be between 0 and 65535");
		}
		this.data = data & 0x0000FFFF;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		out.write(ByteUtils.convertIntTo2ByteArray(this.data));
		return 2;
	}
	
	
}
