package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class ItsAidPriority extends WaveElement {

	// ---- fields ----

	@Internal(order = 0)
	private IntX itsAid;

	@Internal(order = 1)
	private UInt8 maxPriority;

	// ---- fields ----

	// ---- constructors ----

	public ItsAidPriority() {
	}
	
	public ItsAidPriority(long itsAid, int maxPriority) {
		this.itsAid = new IntX(itsAid);
		this.maxPriority = new UInt8(maxPriority);
	}

	public ItsAidPriority(DataInputStream in) throws IOException {
		itsAid = new IntX(in);
		maxPriority = new UInt8(in);
	}

	// ---- accept ----

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	// ---- getter ----

	public IntX getItsAid() {
		return this.itsAid;
	}

	public UInt8 getMaxPriority() {
		return this.maxPriority;
	}

	// ---- setter ----

	public void setItsAid(IntX itsAid) {
		this.itsAid = itsAid;
	}

	public void setMaxPriority(UInt8 maxPriority) {
		this.maxPriority = maxPriority;
	}

	@Override
	public String toString() {
		return "ItsAidPriority [itsAid=" + itsAid.getValue() + ", maxPriority=" + maxPriority.get() + "]";
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		if (itsAid == null || maxPriority == null) {
			throw new IllegalArgumentException();
		}
		int written = 0;
		written += itsAid.writeData(out);
		written += maxPriority.writeData(out);
		return written;
	}
}