package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.ca.utils.WaveUtils;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.RegionTypeImpl.RegionType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class GeographicRegion extends WaveElement implements
		de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.GeographicRegion {

	// ---- fields ----

	@Internal(order = 0)
	private RegionType regionType;

	@Internal(order = 1)
	private CircularRegion circularRegion;

	@Internal(order = 2)
	private RectangularRegion[] rectangularRegion;

	@Internal(order = 3)
	private PolygonalRegion polygonalRegion;

	@Internal(order = 4)
	private IdentifiedRegion idRegion;

	@Internal(order = 5)
	private Opaque otherRegion;

	// ---- fields ----

	// ---- constructors ----
	public GeographicRegion() {
	}

	public GeographicRegion(RegionType type) {
		this.regionType = type;
	}

	public GeographicRegion(IdentifiedRegion idRegion) {
		setIdRegion(idRegion);
	}
	
	public GeographicRegion(CircularRegion circularRegion) {
		setCircularRegion(circularRegion);
	}
	
	public GeographicRegion(RectangularRegion[] rectangularRegions) {
		setRectangularRegion(rectangularRegions);
	}
	
	public GeographicRegion(PolygonalRegion polygonalRegion) {
		setPolygonalRegion(polygonalRegion);
	}

	public GeographicRegion(DataInputStream in) throws IOException {
		this.regionType = RegionTypeImpl.getInstance().getEnumType(in.readByte());
		if (regionType == RegionType.CIRCLE) {
			circularRegion = new CircularRegion(in);
		} else if (regionType == RegionType.RECTANGLE) {
			setRectangularRegion(WaveUtils.getArrayFromStream(in, RectangularRegion.class));
		} else if (regionType == RegionType.POLYGON) {
			polygonalRegion = new PolygonalRegion(in);
		} else if (regionType == RegionType.ID) {
			idRegion = new IdentifiedRegion(in);
		} else if (regionType == RegionType.NONE) {
		} else {
			otherRegion = new Opaque(in);
		}

	}

	// ---- accept ----

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	// ---- getter ----

	public RegionType getRegionType() {
		return this.regionType;
	}

	public CircularRegion getCircularRegion() {
		return this.circularRegion;
	}

	public RectangularRegion[] getRectangularRegion() {
		if (rectangularRegion.length > 6)
			throw new IllegalArgumentException("The number of rectangles shall not exceed 6!");
		return this.rectangularRegion;
	}

	public PolygonalRegion getPolygonalRegion() {
		return this.polygonalRegion;
	}

	public IdentifiedRegion getIdRegion() {
		return this.idRegion;
	}

	public de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.CircularRegion getICircularRegion() {
		return this.circularRegion;
	}

	@Override
	public de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.RectangularRegion[] getIRectangularRegion() {
		if (rectangularRegion != null && rectangularRegion.length > 6)
			throw new IllegalArgumentException("The number of rectangles shall not exceed 6!");
		return this.rectangularRegion;
	}

	@Override
	public de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.PolygonalRegion getIPolygonalRegion() {
		return this.polygonalRegion;
	}

	@Override
	public de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.IdentifiedRegion getIIdRegion() {
		return this.idRegion;
	}

	public Opaque getOtherRegion() {
		return this.otherRegion;
	}

	// ---- setter ----

	public void setRegionType(RegionType regionType) {
		this.regionType = regionType;
	}

	public void setCircularRegion(CircularRegion circularRegion) {
		this.regionType = RegionType.CIRCLE;
		this.circularRegion = circularRegion;
	}

	public void setRectangularRegion(RectangularRegion[] rectangularRegion) {
		if (rectangularRegion.length > 6)
			throw new IllegalArgumentException("The number of rectangles shall not exceed 6!");
		this.regionType = RegionType.RECTANGLE;
		this.rectangularRegion = rectangularRegion;
	}

	public void setPolygonalRegion(PolygonalRegion polygonalRegion) {
		this.regionType = RegionType.POLYGON;
		this.polygonalRegion = polygonalRegion;
	}

	public void setIdRegion(IdentifiedRegion idRegion) {
		this.regionType = RegionType.ID;
		this.idRegion = idRegion;
	}

	public void setOtherRegion(Opaque otherRegion) {
		this.otherRegion = otherRegion;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		if (regionType == null) {
			throw new IllegalArgumentException();
		}
		int written = RegionTypeImpl.getInstance().writeData(out, regionType);
		if (regionType == RegionType.CIRCLE) {
			if (circularRegion == null) {
				throw new IllegalArgumentException("args may not be null");
			}
			written += circularRegion.writeData(out);
		} else if (regionType == RegionType.RECTANGLE) {
			if (rectangularRegion == null) {
				throw new IllegalArgumentException("args may not be null");
			}
			if (rectangularRegion.length > 6) {
				throw new IllegalArgumentException("The number of rectangles shall not exceed 6!");
			}
			written += WaveUtils.writeArrayToStream(out, rectangularRegion);
		} else if (regionType == RegionType.POLYGON) {
			if (polygonalRegion == null) {
				throw new IllegalArgumentException("args may not be null");
			}
			written += polygonalRegion.writeData(out);
		} else if (regionType == RegionType.ID) {
			if (idRegion == null) {
				throw new IllegalArgumentException("args may not be null");
			}
			written += idRegion.writeData(out);
		} else if (regionType == RegionType.NONE) {
		} else {
			written += otherRegion.writeData(out);
		}
		return written;
	}

}