#pragma once

using namespace std;
//class OCTETSTRING;
//class TTCN_Buffer;
//class TTCN_Logger;
//extern void TTCN_error(const char *err_msg, ...);
#include <TTCN3.hh>

namespace loggers {

    class loggers {
    public:
        inline static void log_to_hexa(const char *prompt, const TTCN_Buffer & buffer);
        inline static void log_to_hexa(const char *prompt, const OCTETSTRING& msg);
        inline static void log_msg(const char *prompt, const Base_Type& type);
        inline static void log(const char *fmt, ...);
        inline static void error(const char *fmt, ...);
    };

    void loggers::log_to_hexa(const char *prompt, const TTCN_Buffer & buffer)
    {
        TTCN_Logger::begin_event(TTCN_Logger::DEBUG_UNQUALIFIED);
        TTCN_Logger::log_event_str(prompt);
        buffer.log();
        TTCN_Logger::end_event();
//        TTCN_Logger::begin_event(TTCN_Logger::DEBUG_UNQUALIFIED);
//        int len = buffer->get_read_len();
//        const unsigned char* ptr = buffer->get_read_data();
//        for(int i = buffer->get_pos(); i < len; i++)
//        {
//            TTCN_Logger::log_event(" %02X", ptr[i]);
//        }
//        TTCN_Logger::end_event();
    }

    void loggers::log_to_hexa(const char *prompt, const OCTETSTRING& msg)
    {
      TTCN_Logger::begin_event(TTCN_Logger::DEBUG_UNQUALIFIED);
      TTCN_Logger::log_event_str(prompt);
      TTCN_Logger::log_event("Size: %d,\nMsg: ",msg.lengthof());

      for(int i=0; i<msg.lengthof(); i++)
        TTCN_Logger::log_event(" %02x", ((const unsigned char*)msg)[i]);
      TTCN_Logger::log_event("\n");
      TTCN_Logger::end_event();
    }

    void loggers::log_msg(const char *prompt, const Base_Type& type)
    {
        TTCN_Logger::begin_event(TTCN_Logger::DEBUG_UNQUALIFIED);
        TTCN_Logger::log_event_str(prompt);
        type.log();
        TTCN_Logger::end_event();
    }

    void loggers::log(const char *fmt, ...)
    {
        TTCN_Logger::begin_event(TTCN_Logger::DEBUG_UNQUALIFIED);
        va_list args;
        va_start(args, fmt);
        TTCN_Logger::log_event_va_list(fmt, args);
        va_end(args);
        TTCN_Logger::end_event();
    }

    void loggers::error(const char *fmt, ...)
    {
        va_list args;
        va_start(args, fmt);
        TTCN_error(fmt, args);
        va_end(args);
    }

}

using namespace loggers;
