#include "GeoNetworkingLayer.hh"
#include "GeoNetworkingTypes.hh"

#include "loggers.hh"

GeoNetworkingLayer::GeoNetworkingLayer(const std::string & type, const std::string & param) : GeoNetworkingLayer() {
    loggers::loggers::log(">>> GeoNetworkingLayer::GeoNetworkingLayer: %s, %s", type.c_str(), param.c_str());

}

void GeoNetworkingLayer::sendMsg(const LibItsGeoNetworking__TestSystem::GeoNetworkingReq& p, const Params& params) {
    loggers::loggers::log(">>> GeoNetworkingLayer::sendMsg");
    const LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu & pdu = p.msgOut();
    OCTETSTRING data;
    _codec.encode(pdu, data);
    const unsigned char mac_address[] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
    data += OCTETSTRING(sizeof(mac_address), static_cast<const unsigned char *>(mac_address));
    sendData(data, params);
}

void GeoNetworkingLayer::sendData(const OCTETSTRING& data, const Params& params) {
    sendToAllLayers(data, params);
}

void GeoNetworkingLayer::receiveData(const OCTETSTRING& data, const Params& info) {
    LibItsGeoNetworking__TestSystem::GeoNetworkingInd p;
//    _codec.decode(data, p);

    toAllUpperPorts(p, info);

//    if (p.payload().is_present()) {
//        toAllUpperLayers(p.payload()().rawPayload(), info);
//    }
}

class GeoNetworkingFactory: public LayerFactory {
    static GeoNetworkingFactory _f;
public:
    GeoNetworkingFactory();
    virtual Layer * createLayer(const std::string & type,
            const std::string & param);
};

GeoNetworkingFactory::GeoNetworkingFactory() {
    // register factory
    loggers::loggers::log(">>> GeoNetworkingFactory::GeoNetworkingFactory");
    LayerStackBuilder::RegisterLayerFactory("GN", this);
}

Layer * GeoNetworkingFactory::createLayer(const std::string & type, const std::string & param) {
    return new GeoNetworkingLayer(type, param);
}

GeoNetworkingFactory GeoNetworkingFactory::_f;
