#ifndef GNCODEC_H
#define GNCODEC_H

#include <vector>

#include "Codec.hh"

class Base_Type;
class OCTETSTRING;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;


namespace LibItsGeoNetworking__TypesAndValues {
    class GeoNetworkingPdu;
    class ExtendedHeader;
    class DecodedPayload;
}

struct Encoding_Context {
    unsigned char next_header; // FIXME Useless?
    unsigned char header_type; // FIXME Useless?
    unsigned int  plLength_position;
    unsigned int  plLength;

    Encoding_Context() { next_header = 0xff; header_type = 0xff; plLength_position = -1; plLength = -1; }
};

struct Decoding_Context {
    unsigned char              next_header; // FIXME Useless?
    unsigned char              header_type; // FIXME Useless?
    unsigned char              header_sub_type; // FIXME Useless?
    unsigned int               plLength;
    std::vector<unsigned char> payload;

    Decoding_Context() : payload() { next_header = 0xff; header_type = 0xff; header_sub_type = 0xff; plLength = -1; }
};

class GeoNetworkingCodec : public Codec<LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu, LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu> {

    Encoding_Context _ec;
    Decoding_Context _dc;

    int encode_ (const Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& encoding_buffer);
    int encode_extendedHeader(const LibItsGeoNetworking__TypesAndValues::ExtendedHeader& u, TTCN_Buffer& encoding_buffer);
    int encode_decodedPayload(const LibItsGeoNetworking__TypesAndValues::DecodedPayload& u, TTCN_Buffer& encoding_buffer);

    int decode_ (Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& decoding_buffer);
    int decode_extendedHeader(LibItsGeoNetworking__TypesAndValues::ExtendedHeader& u, TTCN_Buffer& decoding_buffer);


public:
    GeoNetworkingCodec() : _ec(), _dc() {};

    virtual int encode (const LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu& msg, OCTETSTRING& data);
    virtual int decode (const OCTETSTRING& data, LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu& msg);
};

#endif
